/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.metadata;

import com.bc.ceres.metadata.XPathHandler;
import org.junit.Assert;
import org.junit.Test;

public class XPathHandlerTest {
    @Test
    public void testRun_1() throws Exception {
        XPathHandler xPathHandler = new XPathHandler();
        String document = "<package>\n    <class name=\"Director\">\n        <field name=\"test1\"/>\n    </class>\n</package>\n";
        String result = xPathHandler.run("//package/class/@name", (Object)document);
        Assert.assertEquals((Object)"Director", (Object)result);
    }

    @Test
    public void testRun_2() throws Exception {
        XPathHandler xPathHandler = new XPathHandler();
        String document = "<package>\n    <class name=\"Director\">\n        <field name=\"test1\">Headquaters</field>\n    </class>\n</package>";
        String result = xPathHandler.run("//package/class/field", (Object)document);
        Assert.assertEquals((Object)"Headquaters", (Object)result);
    }

    @Test
    public void testRun_3() throws Exception {
        XPathHandler xPathHandler = new XPathHandler();
        String document = "<package>\n    <class name=\"Director\">\n        <field name=\"test1\">Headquaters</field>\n    </class>\n</package>";
        String result = xPathHandler.run("//field/@name", (Object)document);
        Assert.assertEquals((Object)"test1", (Object)result);
    }

    @Test
    public void testExtractXml() throws Exception {
        XPathHandler xPathHandler = new XPathHandler();
        String document = "  <metadata>  <name>some name</name>  <steps>\n        <step>\n            <processor>\n                <name>Subset</name>\n                <version>1.0</version>\n            </processor>\n            <parameters>\n                <fullSwath>false</fullSwath>\n                <copyMetadata>false</copyMetadata>\n                <subSamplingX>1</subSamplingX>\n                <subSamplingY>1</subSamplingY>\n            </parameters>\n        </step>\n        <step>\n            <processor>\n                <name>Meris.CorrectRadiometry</name>\n                <version>1.1</version>\n            </processor>\n            <parameters>\n                <doRadToRefl>false</doRadToRefl>\n                <doCalibration>true</doCalibration>\n                <doSmile>true</doSmile>\n                <doEqualization>true</doEqualization>\n                <reproVersion>REPROCESSING_3</reproVersion>\n            </parameters>\n        </step>    </steps></metadata>";
        String result1 = xPathHandler.extractXml("//steps/step[1]", (Object)document);
        String expected1 = "<step>\n            <processor>\n                <name>Subset</name>\n                <version>1.0</version>\n            </processor>\n            <parameters>\n                <fullSwath>false</fullSwath>\n                <copyMetadata>false</copyMetadata>\n                <subSamplingX>1</subSamplingX>\n                <subSamplingY>1</subSamplingY>\n            </parameters>\n        </step>";
        Assert.assertEquals((Object)"<step>\n            <processor>\n                <name>Subset</name>\n                <version>1.0</version>\n            </processor>\n            <parameters>\n                <fullSwath>false</fullSwath>\n                <copyMetadata>false</copyMetadata>\n                <subSamplingX>1</subSamplingX>\n                <subSamplingY>1</subSamplingY>\n            </parameters>\n        </step>", (Object)result1);
        String result2 = xPathHandler.extractXml("//steps/step[2]", (Object)document);
        String expected2 = "<step>\n            <processor>\n                <name>Meris.CorrectRadiometry</name>\n                <version>1.1</version>\n            </processor>\n            <parameters>\n                <doRadToRefl>false</doRadToRefl>\n                <doCalibration>true</doCalibration>\n                <doSmile>true</doSmile>\n                <doEqualization>true</doEqualization>\n                <reproVersion>REPROCESSING_3</reproVersion>\n            </parameters>\n        </step>";
        Assert.assertEquals((Object)"<step>\n            <processor>\n                <name>Meris.CorrectRadiometry</name>\n                <version>1.1</version>\n            </processor>\n            <parameters>\n                <doRadToRefl>false</doRadToRefl>\n                <doCalibration>true</doCalibration>\n                <doSmile>true</doSmile>\n                <doEqualization>true</doEqualization>\n                <reproVersion>REPROCESSING_3</reproVersion>\n            </parameters>\n        </step>", (Object)result2);
    }
}

