/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.metadata;

import com.bc.ceres.metadata.MetadataResourceResolver;
import com.bc.ceres.metadata.SimpleFileSystem;
import java.util.SortedMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class MetadataResourceResolverTest {
    @Test
    public void testRemovefileExtension() throws Exception {
        SimpleFileSystem fileSystem = (SimpleFileSystem)Mockito.mock(SimpleFileSystem.class);
        MetadataResourceResolver metadataResourceResolver = new MetadataResourceResolver(fileSystem);
        Mockito.when((Object)fileSystem.isFile(Matchers.anyString())).thenReturn((Object)true);
        Assert.assertEquals((Object)"foo", (Object)metadataResourceResolver.removeFileExtension("foo.txt"));
        Assert.assertEquals((Object)"foo", (Object)metadataResourceResolver.removeFileExtension("foo"));
        Assert.assertEquals((Object)"foo/bar", (Object)metadataResourceResolver.removeFileExtension("foo/bar.baz"));
        Assert.assertEquals((Object)"foo\\bar", (Object)metadataResourceResolver.removeFileExtension("foo\\bar.baz"));
        Mockito.when((Object)fileSystem.isFile(Matchers.anyString())).thenReturn((Object)false);
        Assert.assertEquals((Object)"bar.foo", (Object)metadataResourceResolver.removeFileExtension("bar.foo"));
        Assert.assertEquals((Object)"\\root\\foo", (Object)metadataResourceResolver.removeFileExtension("\\root\\foo"));
        String directory = "C:\\Users\\bettina\\Software-Tests\\own-software\\ceres-metadata-0.13.2-SNAPSHOT\\data\\out";
        Assert.assertEquals((Object)directory, (Object)metadataResourceResolver.removeFileExtension(directory));
        Assert.assertEquals((Object)"/root/foo/", (Object)metadataResourceResolver.removeFileExtension("/root/foo/"));
    }

    @Test
    public void testBasename() throws Exception {
        Assert.assertEquals((Object)"foo.txt", (Object)MetadataResourceResolver.getBasename((String)"foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)MetadataResourceResolver.getBasename((String)"/foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)MetadataResourceResolver.getBasename((String)"./foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)MetadataResourceResolver.getBasename((String)"bar/foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)MetadataResourceResolver.getBasename((String)"/bar/foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)MetadataResourceResolver.getBasename((String)"\\foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)MetadataResourceResolver.getBasename((String)".\\foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)MetadataResourceResolver.getBasename((String)"bar\\foo.txt"));
        Assert.assertEquals((Object)"foo.txt", (Object)MetadataResourceResolver.getBasename((String)"\\bar\\foo.txt"));
    }

    @Test
    public void testDirname() throws Exception {
        Assert.assertEquals((Object)"", (Object)MetadataResourceResolver.getDirname((String)"foo.txt"));
        Assert.assertEquals((Object)"", (Object)MetadataResourceResolver.getDirname((String)"/foo.txt"));
        Assert.assertEquals((Object)".", (Object)MetadataResourceResolver.getDirname((String)"./foo.txt"));
        Assert.assertEquals((Object)"bar", (Object)MetadataResourceResolver.getDirname((String)"bar/foo.txt"));
        Assert.assertEquals((Object)"/bar", (Object)MetadataResourceResolver.getDirname((String)"/bar/foo.txt"));
        Assert.assertEquals((Object)"", (Object)MetadataResourceResolver.getDirname((String)"\\foo.txt"));
        Assert.assertEquals((Object)".", (Object)MetadataResourceResolver.getDirname((String)".\\foo.txt"));
        Assert.assertEquals((Object)"bar", (Object)MetadataResourceResolver.getDirname((String)"bar\\foo.txt"));
        Assert.assertEquals((Object)"C:/bar", (Object)MetadataResourceResolver.getDirname((String)"C:\\bar\\foo.txt"));
    }

    @Test
    public void testGetSourceNames() throws Exception {
        SimpleFileSystem fileSystem = (SimpleFileSystem)Mockito.mock(SimpleFileSystem.class);
        MetadataResourceResolver resolver = new MetadataResourceResolver(fileSystem);
        Mockito.when((Object)fileSystem.isFile(Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)fileSystem.list(Mockito.anyString())).thenReturn((Object)new String[]{"file1", "product-file2.xml", "file3", "product-file4.properties"});
        SortedMap sourceMetadataPaths = resolver.getSourceMetadataPaths("/bla/bli/product.dim");
        Assert.assertEquals((long)2L, (long)sourceMetadataPaths.size());
        Assert.assertEquals((Object)"/bla/bli/product-file2.xml", sourceMetadataPaths.get("file2.xml"));
        Assert.assertEquals((Object)"/bla/bli/product-file4.properties", sourceMetadataPaths.get("file4.properties"));
    }
}

