/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.util;

import com.bc.ceres.util.TemplateReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;

public class TemplateReaderTest
extends TestCase {
    public void testNullArgConvention() {
        try {
            new TemplateReader(null, (Map)new Properties());
            TemplateReaderTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new TemplateReader((Reader)new StringReader(""), (Map)null);
            TemplateReaderTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        try {
            new TemplateReader((Reader)new StringReader(""), (TemplateReader.Resolver)null);
            TemplateReaderTest.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testWithoutProperties() throws IOException {
        Properties properties = new Properties();
        TemplateReaderTest.test(properties, "<module><symbolicName>my-module</symbolicName></module>", "<module><symbolicName>my-module</symbolicName></module>");
        TemplateReaderTest.test(properties, "<module><symbolicName>${id}</symbolicName></module>", "<module><symbolicName>${id}</symbolicName></module>");
    }

    public void testWithProperties() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("id", "com.bc.x");
        TemplateReaderTest.test(properties, "<module><symbolicName>my-module</symbolicName></module>", "<module><symbolicName>my-module</symbolicName></module>");
        TemplateReaderTest.test(properties, "<module><symbolicName>$id</symbolicName></module>", "<module><symbolicName>com.bc.x</symbolicName></module>");
        TemplateReaderTest.test(properties, "<module><symbolicName>${id}</symbolicName></module>", "<module><symbolicName>com.bc.x</symbolicName></module>");
        TemplateReaderTest.test(properties, "<module><symbolicName>${id}</symbolicName><version>${version}</version></module>", "<module><symbolicName>com.bc.x</symbolicName><version>${version}</version></module>");
        properties.setProperty("version", "1.0");
        TemplateReaderTest.test(properties, "<module><symbolicName>${id}</symbolicName><version>${version}</version></module>", "<module><symbolicName>com.bc.x</symbolicName><version>1.0</version></module>");
    }

    public void testReplacementAtEOF() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("bar", "foo");
        TemplateReaderTest.test(properties, "blah, blah, $bar", "blah, blah, foo");
        TemplateReaderTest.test(properties, "blah, blah, ${bar}", "blah, blah, foo");
    }

    public void testReplacementAtBOF() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("bar", "foo");
        TemplateReaderTest.test(properties, "$bar, blah, blah", "foo, blah, blah");
        TemplateReaderTest.test(properties, "${bar}, blah, blah", "foo, blah, blah");
    }

    public void testSubsequentReplacements() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("bar", "foo");
        TemplateReaderTest.test(properties, "$bar$bar, blah, blah", "$bar$bar, blah, blah");
        TemplateReaderTest.test(properties, "${bar} ${bar}, blah, blah", "foo foo, blah, blah");
        TemplateReaderTest.test(properties, "${bar}-${bar}, blah, blah", "foo-foo, blah, blah");
    }

    public void testNotReplaceable() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("bar", "foo");
        TemplateReaderTest.test(properties, "${bar, blah, blah", "${bar, blah, blah");
        TemplateReaderTest.test(properties, "blah, blah ${bar", "blah, blah ${bar");
        TemplateReaderTest.test(properties, "blah, blah $-bar", "blah, blah $-bar");
    }

    public void testEmptyValues() throws IOException {
        Properties properties = new Properties();
        properties.setProperty("emptyValue", "");
        properties.setProperty("spaceValue", " ");
        properties.setProperty("nlValue", "\n");
        TemplateReaderTest.test(properties, "$emptyValue", "");
        TemplateReaderTest.test(properties, "$spaceValue", " ");
        TemplateReaderTest.test(properties, "$nlValue", "\n");
        TemplateReaderTest.test(properties, "${emptyValue}", "");
        TemplateReaderTest.test(properties, "${spaceValue}", " ");
        TemplateReaderTest.test(properties, "${nlValue}", "\n");
        TemplateReaderTest.test(properties, "$emptyValue more text", " more text");
        TemplateReaderTest.test(properties, "$spaceValue more text", "  more text");
        TemplateReaderTest.test(properties, "$nlValue more text", "\n more text");
        TemplateReaderTest.test(properties, "${emptyValue}_more text", "_more text");
        TemplateReaderTest.test(properties, "${spaceValue}_more text", " _more text");
        TemplateReaderTest.test(properties, "${nlValue}_more text", "\n_more text");
    }

    private static void test(Properties properties, String input, String expectedOutput) throws IOException {
        StringReader stringReader = new StringReader(input);
        TemplateReader templateReader = new TemplateReader((Reader)stringReader, (Map)properties);
        String actualOutput = templateReader.readAll();
        TemplateReaderTest.assertEquals((String)expectedOutput, (String)actualOutput);
    }
}

