/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.launcher.internal;

import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeConfigException;
import com.bc.ceres.core.runtime.support.DefaultRuntimeConfig;
import com.bc.ceres.launcher.internal.AbstractClasspathFactory;
import com.bc.ceres.launcher.internal.BootstrapClasspathFactory;
import java.io.File;
import junit.framework.TestCase;

public class BootstrapClasspathFactoryTest
extends TestCase {
    public void testGetFiles() throws RuntimeConfigException {
        DefaultRuntimeConfig config = new DefaultRuntimeConfig();
        BootstrapClasspathFactory btcf = new BootstrapClasspathFactory((RuntimeConfig)config);
        btcf.processClasspathFile(new File("lib/xpp3-1.3.4.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/xstream-1.2.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/jdom-1.0.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/jhall-2.0.4.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/snap-launcher.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("modules/snap-ceres-core-1.0.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        btcf.processClasspathFile(new File("modules/snap-ceres-ui-1.0.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        btcf.processClasspathFile(new File("modules/snap-core-4.0.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        File[] files = btcf.getClasspathFiles();
        BootstrapClasspathFactoryTest.assertEquals((int)5, (int)files.length);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("modules/snap-ceres-core-1.0.jar"), (Object)files[0]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/xpp3-1.3.4.jar"), (Object)files[1]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/xstream-1.2.jar"), (Object)files[2]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/jdom-1.0.jar"), (Object)files[3]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/jhall-2.0.4.jar"), (Object)files[4]);
    }

    public void testGetFilesWithMultCeresCore_1() throws RuntimeConfigException {
        DefaultRuntimeConfig config = new DefaultRuntimeConfig();
        BootstrapClasspathFactory btcf = new BootstrapClasspathFactory((RuntimeConfig)config);
        btcf.processClasspathFile(new File("lib/xpp3-1.3.4.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/xstream-1.2.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/jdom-1.0.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/jhall-2.0.4.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/snap-launcher.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("modules/snap-ceres-core-1.0.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        btcf.processClasspathFile(new File("modules/snap-ceres-core-1.0.1.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        btcf.processClasspathFile(new File("modules/snap-ceres-ui-1.0.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        btcf.processClasspathFile(new File("modules/snap-core-4.0.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        File[] files = btcf.getClasspathFiles();
        BootstrapClasspathFactoryTest.assertEquals((int)5, (int)files.length);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("modules/snap-ceres-core-1.0.1.jar"), (Object)files[0]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/xpp3-1.3.4.jar"), (Object)files[1]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/xstream-1.2.jar"), (Object)files[2]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/jdom-1.0.jar"), (Object)files[3]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/jhall-2.0.4.jar"), (Object)files[4]);
    }

    public void testGetFilesWithMultCeresCore_2() throws RuntimeConfigException {
        DefaultRuntimeConfig config = new DefaultRuntimeConfig();
        BootstrapClasspathFactory btcf = new BootstrapClasspathFactory((RuntimeConfig)config);
        btcf.processClasspathFile(new File("lib/xpp3-1.3.4.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/xstream-1.2.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/jdom-1.0.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/jhall-2.0.4.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("lib/snap-launcher.jar"), AbstractClasspathFactory.LibType.LIBRARY, 0);
        btcf.processClasspathFile(new File("modules/snap-ceres-core-1.0.1.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        btcf.processClasspathFile(new File("modules/snap-ceres-core-1.2.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        btcf.processClasspathFile(new File("modules/snap-ceres-ui-1.0.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        btcf.processClasspathFile(new File("modules/snap-core-4.0.jar"), AbstractClasspathFactory.LibType.MODULE, 0);
        File[] files = btcf.getClasspathFiles();
        BootstrapClasspathFactoryTest.assertEquals((int)5, (int)files.length);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("modules/snap-ceres-core-1.2.jar"), (Object)files[0]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/xpp3-1.3.4.jar"), (Object)files[1]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/xstream-1.2.jar"), (Object)files[2]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/jdom-1.0.jar"), (Object)files[3]);
        BootstrapClasspathFactoryTest.assertEquals((Object)new File("lib/jhall-2.0.4.jar"), (Object)files[4]);
    }
}

