/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.launcher;

import com.bc.ceres.core.runtime.AbstractRuntimeTest;
import com.bc.ceres.core.runtime.RuntimeConfigException;
import com.bc.ceres.launcher.Launcher;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class LauncherTest
extends AbstractRuntimeTest {
    private static final boolean YES = true;
    private static final boolean NO_ = false;

    @Override
    protected void setUp() throws Exception {
        this.clearContextSystemProperties("x");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.clearContextSystemProperties("x");
    }

    public void testBootstrapClasspathFactory() throws RuntimeConfigException, IOException {
        this.initContextHomeDir("x", "x-app", "");
        System.setProperty("ceres.context", "x");
        System.setProperty("x.home", this.getBaseDirPath() + "/x-app");
        System.setProperty("x.app", "bibo");
        System.setProperty("x.mainClass", "com.bc.ceres.core.runtime.RuntimeLauncher");
        System.setProperty("x.classpath", "." + File.pathSeparator + "x-app");
        Launcher defaultLauncher = Launcher.createDefaultLauncher();
        List<URL> cp1 = Arrays.asList(defaultLauncher.createMainClasspath());
        LauncherTest.assertEquals((int)2, (int)cp1.size());
        this.testInMainClasspath(true, cp1, "x-app");
        this.testInMainClasspath(true, cp1, ".");
        List<URL> cp2 = Arrays.asList(defaultLauncher.createDefaultClasspath());
        this.testInDefaultClasspath(false, cp2, "x-app");
        this.testInDefaultClasspath(false, cp2, "x-app/config");
        this.testInDefaultClasspath(false, cp2, "x-app/lib");
        this.testInDefaultClasspath(false, cp2, "x-app/lib/snap-launcher-0.5.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/lib/xstream-1.2.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/lib/xpp3-1.1.3.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/lib/jdom-1.0.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/lib/lib-jide-1.9");
        this.testInDefaultClasspath(false, cp2, "x-app/modules");
        this.testInDefaultClasspath(true, cp2, "x-app/modules/snap-ceres-core-0.5.jar");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/snap-ceres-ui-0.5.jar");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/beam-core-4.0.jar");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/beam-ui-4.0.jar");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/lib-netcdf");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/lib-netcdf/lib");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/lib-netcdf/lib/nc-core.jar");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/lib-hdf");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/lib-hdf/lib");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/lib-hdf/lib/jhdf.jar");
        this.clearContextSystemProperties("x");
    }

    public void testBruteForceClasspathFactory() throws RuntimeConfigException, IOException {
        this.clearContextSystemProperties("x");
        this.initContextHomeDir("x", "x-app", "");
        System.setProperty("ceres.context", "x");
        System.setProperty("x.home", this.getBaseDirPath() + "/x-app");
        System.setProperty("x.app", "bibo");
        System.setProperty("x.mainClass", LauncherTest.class.getName());
        System.setProperty("x.classpath", "." + File.pathSeparator + "x-app");
        Launcher defaultLauncher = Launcher.createDefaultLauncher();
        System.clearProperty("ceres.context");
        System.clearProperty("x.home");
        System.clearProperty("x.app");
        System.clearProperty("x.mainClass");
        System.clearProperty("x.classpath");
        List<URL> cp1 = Arrays.asList(defaultLauncher.createMainClasspath());
        LauncherTest.assertEquals((int)2, (int)cp1.size());
        this.testInMainClasspath(true, cp1, "x-app");
        this.testInMainClasspath(true, cp1, ".");
        List<URL> cp2 = Arrays.asList(defaultLauncher.createDefaultClasspath());
        this.testInDefaultClasspath(false, cp2, "x-app");
        this.testInDefaultClasspath(false, cp2, "x-app/config");
        this.testInDefaultClasspath(false, cp2, "x-app/lib");
        this.testInDefaultClasspath(false, cp2, "x-app/lib/snap-launcher-0.5.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/lib/xstream-1.2.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/lib/xpp3-1.1.3.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/lib/jdom-1.0.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/lib/lib-jide-1.9");
        this.testInDefaultClasspath(false, cp2, "x-app/modules");
        this.testInDefaultClasspath(true, cp2, "x-app/modules/snap-ceres-core-0.5.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/modules/snap-ceres-ui-0.5.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/modules/beam-core-4.0.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/modules/beam-ui-4.0.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/modules/lib-netcdf");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/lib-netcdf/lib");
        this.testInDefaultClasspath(true, cp2, "x-app/modules/lib-netcdf/lib/nc-core.jar");
        this.testInDefaultClasspath(true, cp2, "x-app/modules/lib-hdf");
        this.testInDefaultClasspath(false, cp2, "x-app/modules/lib-hdf/lib");
        this.testInDefaultClasspath(true, cp2, "x-app/modules/lib-hdf/lib/jhdf.jar");
    }

    private void testInMainClasspath(boolean expected, List<URL> classpath, String filePath) throws IOException {
        this.testInClasspath(expected, classpath, this.toMainURL(filePath));
    }

    private void testInDefaultClasspath(boolean expected, List<URL> classpath, String filePath) throws IOException {
        this.testInClasspath(expected, classpath, this.toDefaultURL(filePath));
    }

    private void testInClasspath(boolean expected, List<URL> classpath, URL url) {
        LauncherTest.assertEquals((String)("Is [" + url + "] a classpath entry ? :"), (boolean)expected, (boolean)classpath.contains(url));
    }
}

