/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime.support;

import com.bc.ceres.core.runtime.AbstractRuntimeTest;
import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeConfigException;
import com.bc.ceres.core.runtime.support.DefaultRuntimeConfig;
import java.io.File;
import java.io.IOException;

public class DefaultRuntimeConfigTest
extends AbstractRuntimeTest {
    @Override
    protected void setUp() throws Exception {
        this.clearContextSystemProperties("pacman");
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.clearContextSystemProperties("pacman");
    }

    public void ignore_testWithNoProperties() throws RuntimeConfigException, IOException {
        DefaultRuntimeConfig config = new DefaultRuntimeConfig();
        DefaultRuntimeConfigTest.assertEquals((String)"ceres", (String)config.getContextId());
        File cwd = new File(".").getCanonicalFile();
        boolean hasConfig = new File(cwd, "config/ceres.config").exists();
        boolean hasLib = new File(cwd, "lib").exists();
        boolean hasModules = new File(cwd, "modules").exists();
        DefaultRuntimeConfigTest.assertEquals((Object)cwd, (Object)new File(config.getHomeDirPath()));
        if (hasConfig) {
            DefaultRuntimeConfigTest.assertNotNull((Object)config.getConfigFilePath());
        } else {
            DefaultRuntimeConfigTest.assertNull((Object)config.getConfigFilePath());
        }
        DefaultRuntimeConfigTest.assertNotNull((Object)config.getLibDirPaths());
        if (hasLib) {
            DefaultRuntimeConfigTest.assertEquals((int)1, (int)config.getLibDirPaths().length);
        } else {
            DefaultRuntimeConfigTest.assertEquals((int)0, (int)config.getLibDirPaths().length);
        }
        if (hasModules) {
            DefaultRuntimeConfigTest.assertNotNull((Object)config.getModulesDirPath());
        } else {
            DefaultRuntimeConfigTest.assertNull((Object)config.getModulesDirPath());
        }
        DefaultRuntimeConfigTest.assertEquals((String)"com.bc.ceres.core.runtime.RuntimeLauncher", (String)config.getMainClassName());
        DefaultRuntimeConfigTest.assertEquals(null, (String)config.getMainClassPath());
    }

    public void testWithSystemProperties() throws RuntimeConfigException, IOException {
        String configContent = "# Empty config file\n";
        this.initContextHomeDir("pacman", "pacman-1.3.6", configContent);
        System.setProperty("ceres.context", "pacman");
        System.setProperty("pacman.home", this.getBaseDirPath() + "/pacman-1.3.6");
        System.setProperty("pacman.app", "bibo");
        System.setProperty("pacman.grunt", "foobar");
        System.setProperty("pacman.classpath", "a:b:c");
        DefaultRuntimeConfig config = new DefaultRuntimeConfig();
        this.testConfigPaths((RuntimeConfig)config);
        DefaultRuntimeConfigTest.assertEquals((String)"bibo", (String)config.getApplicationId());
        DefaultRuntimeConfigTest.assertEquals((String)"foobar", (String)config.getContextProperty("grunt"));
        DefaultRuntimeConfigTest.assertEquals((String)"a:b:c", (String)config.getMainClassPath());
    }

    public void testWithConfigProperties() throws RuntimeConfigException, IOException {
        String configContent = "pacman.home  = " + this.getBaseDirPath() + "/pacman-1.3.6\n" + "pacman.app   = bibo\n" + "pacman.grunt = foobar\n" + "pacman.classpath = a:b:e\n";
        this.initContextHomeDir("pacman", "pacman-1.3.6", configContent);
        System.setProperty("ceres.context", "pacman");
        System.setProperty("pacman.config", this.getBaseDirPath() + "/pacman-1.3.6/config/pacman.config");
        DefaultRuntimeConfig config = new DefaultRuntimeConfig();
        this.testConfigPaths((RuntimeConfig)config);
        DefaultRuntimeConfigTest.assertEquals((String)"bibo", (String)config.getApplicationId());
        DefaultRuntimeConfigTest.assertEquals((String)"foobar", (String)config.getContextProperty("grunt"));
        DefaultRuntimeConfigTest.assertEquals((String)"a:b:e", (String)config.getMainClassPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWithNoHomeNoConfig() throws RuntimeConfigException, IOException {
        String configContent = "pacman.app  = bibo\npacman.grunt = foobar\npacman.classpath = a:b\n";
        this.initContextHomeDir("pacman", "pacman-1.3.6", configContent);
        String oldUserDir = System.getProperty("user.dir", "");
        System.setProperty("user.dir", new File(this.getBaseDirPath(), "pacman-1.3.6").getPath());
        try {
            System.setProperty("ceres.context", "pacman");
            System.setProperty("pacman.debug", "true");
            DefaultRuntimeConfig config = new DefaultRuntimeConfig();
            this.testConfigPaths((RuntimeConfig)config);
            DefaultRuntimeConfigTest.assertEquals((String)"bibo", (String)config.getApplicationId());
            DefaultRuntimeConfigTest.assertEquals((String)"foobar", (String)config.getContextProperty("grunt"));
            DefaultRuntimeConfigTest.assertEquals((String)"a:b", (String)config.getMainClassPath());
        }
        finally {
            System.setProperty("user.dir", oldUserDir);
        }
    }
}

