/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.core.runtime;

import com.bc.ceres.core.runtime.RuntimeConfig;
import com.bc.ceres.core.runtime.RuntimeConfigException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.TestCase;

public abstract class AbstractRuntimeTest
extends TestCase {
    private ArrayList<File> fileStack = new ArrayList();
    private String baseDirPath;
    private String dirPath;
    private String contextId;

    public String getBaseDirPath() {
        return this.baseDirPath;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public String getContextId() {
        return this.contextId;
    }

    protected void setUp() throws Exception {
        File targetDir = new File("target");
        File testdataDir = new File(targetDir, "test-data");
        this.mkdir0(targetDir);
        this.mkdir0(testdataDir);
        this.baseDirPath = testdataDir.getAbsolutePath();
    }

    protected void tearDown() throws Exception {
        this.deleteFileStack();
    }

    protected void clearContextSystemProperties(String contextId) {
        System.clearProperty("ceres.context");
        System.clearProperty(contextId + ".home");
        System.clearProperty(contextId + ".app");
        System.clearProperty(contextId + ".mainClass");
        System.clearProperty(contextId + ".classpath");
        System.clearProperty(contextId + ".modules");
        System.clearProperty(contextId + ".config");
        System.clearProperty(contextId + ".libDirs");
        System.clearProperty(contextId + ".debug");
        System.clearProperty(contextId + ".logLevel");
        System.clearProperty(contextId + ".consoleLog");
    }

    protected void initContextHomeDir(String contextId, String dirPath, String configContent) throws IOException {
        this.contextId = contextId;
        this.dirPath = dirPath;
        String configFilename = contextId + ".config";
        this.mkdir(dirPath);
        this.mkdir(dirPath + "/config");
        this.touch(dirPath + "/config/" + configFilename, configContent.replace("\\", "/").getBytes());
        this.mkdir(dirPath + "/lib");
        this.touch(dirPath + "/lib/snap-launcher-0.5.jar");
        this.touch(dirPath + "/lib/xstream-1.2.jar");
        this.touch(dirPath + "/lib/xpp3-1.1.3.jar");
        this.touch(dirPath + "/lib/jdom-1.0.jar");
        this.mkdir(dirPath + "/lib/lib-jide-1.9");
        this.mkdir(dirPath + "/modules");
        this.touch(dirPath + "/modules/snap-ceres-core-0.5.jar");
        this.touch(dirPath + "/modules/snap-ceres-ui-0.5.jar");
        this.touch(dirPath + "/modules/beam-core-4.0.jar");
        this.touch(dirPath + "/modules/beam-ui-4.0.jar");
        this.mkdir(dirPath + "/modules/lib-netcdf");
        this.mkdir(dirPath + "/modules/lib-netcdf/lib");
        this.touch(dirPath + "/modules/lib-netcdf/lib/nc-core.jar");
        this.mkdir(dirPath + "/modules/lib-hdf");
        this.mkdir(dirPath + "/modules/lib-hdf/lib");
        this.touch(dirPath + "/modules/lib-hdf/lib/jhdf.jar");
        this.mkdir(dirPath + "/modules/lib-hdf/lib/unix");
        this.touch(dirPath + "/modules/lib-hdf/lib/unix/libhdf.so");
    }

    protected void testConfigPaths(RuntimeConfig config) throws RuntimeConfigException {
        String configFilename = this.contextId + ".config";
        AbstractRuntimeTest.testPath(this.getBaseDirPath() + "/" + this.dirPath, config.getHomeDirPath());
        AbstractRuntimeTest.testPath(this.getBaseDirPath() + "/" + this.dirPath + "/config/" + configFilename, config.getConfigFilePath());
        AbstractRuntimeTest.testPath(this.getBaseDirPath() + "/" + this.dirPath + "/modules", config.getModulesDirPath());
        String[] libDirPaths = config.getLibDirPaths();
        AbstractRuntimeTest.assertNotNull((Object)libDirPaths);
        AbstractRuntimeTest.assertEquals((int)1, (int)libDirPaths.length);
        AbstractRuntimeTest.testPath(this.getBaseDirPath() + "/" + this.dirPath + "/lib", libDirPaths[0]);
    }

    protected static void testPath(String expectedPath, String actualPath) {
        AbstractRuntimeTest.assertNotNull((Object)actualPath);
        try {
            AbstractRuntimeTest.assertEquals((String)new File(expectedPath).getCanonicalPath(), (String)new File(actualPath).getCanonicalPath());
        }
        catch (IOException e) {
            AbstractRuntimeTest.fail((String)("Cannot compare pathes: " + e.getMessage()));
        }
    }

    protected void mkdir(String dirPath) throws IOException {
        this.mkdir0(new File(this.baseDirPath, dirPath));
    }

    protected void touch(String filePath) throws IOException {
        this.touch(filePath, new byte[0]);
    }

    protected void touch(String filePath, byte[] data) throws IOException {
        this.touch0(new File(this.baseDirPath, filePath), data);
    }

    protected URL toMainURL(String filePath) throws IOException {
        return new File(filePath).toURI().toURL();
    }

    protected URL toDefaultURL(String filePath) throws IOException {
        File file = new File(filePath);
        if (file.isAbsolute()) {
            return file.toURI().toURL();
        }
        return new File(this.getBaseDirPath(), file.getPath()).toURI().toURL();
    }

    private void mkdir0(File dir) throws IOException {
        if (dir.mkdir()) {
            if (!dir.isDirectory()) {
                throw new IOException("failed to create " + dir);
            }
            this.addFile(dir);
        }
    }

    private void touch0(File file, byte[] data) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        stream.write(data);
        stream.close();
        this.addFile(file);
    }

    private void addFile(File file) {
        this.fileStack.add(file);
    }

    private void deleteFileStack() {
        for (int i = this.fileStack.size() - 1; i > 0; --i) {
            File file = this.fileStack.get(i);
            boolean b = file.delete();
            if (b) continue;
            System.err.println("failed to delete " + file);
        }
        this.fileStack.clear();
    }
}

