/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import com.bc.ceres.jai.operator.InterpretationType;
import com.bc.ceres.jai.operator.ReinterpretDescriptor;
import com.bc.ceres.jai.operator.ScalingType;
import com.bc.ceres.jai.opimage.ReinterpretOpImage;
import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ReinterpretOpImageTest {
    private static final int W = 10;
    private static final int H = 10;

    @Test
    public void testRescaleByte() {
        this.testRescale(new Byte[]{(byte)-1}, 11.0, 1.0, ReinterpretDescriptor.LINEAR, ReinterpretDescriptor.AWT, 4, 2806.0);
    }

    @Test
    public void testRescaleSByte() {
        this.testRescale(new Byte[]{(byte)-1}, 11.0, 1.0, ReinterpretDescriptor.LINEAR, ReinterpretDescriptor.INTERPRET_BYTE_SIGNED, 4, -10.0);
    }

    @Test
    public void testRescaleInt() {
        this.testRescale(new Integer[]{-1}, 11.0, 1.0, ReinterpretDescriptor.LINEAR, ReinterpretDescriptor.AWT, 5, -10.0);
    }

    @Test
    public void testRescaleUInt() {
        this.testRescale(new Integer[]{-1}, 11.0, 1.0, ReinterpretDescriptor.LINEAR, ReinterpretDescriptor.INTERPRET_INT_UNSIGNED, 5, 4.7244640246E10);
    }

    @Test
    public void testRescaleFloatLin() {
        this.testRescale(new Float[]{Float.valueOf(0.1f)}, 11.0, 1.0, ReinterpretDescriptor.LINEAR, ReinterpretDescriptor.AWT, 4, 2.1000000163912773);
    }

    @Test
    public void testRescaleFloatExp10() {
        this.testRescale(new Float[]{Float.valueOf(0.1f)}, 11.0, 1.0, ReinterpretDescriptor.EXPONENTIAL, ReinterpretDescriptor.AWT, 4, Math.pow(10.0, 2.1000000163912773));
    }

    @Test
    public void testRescaleFloatLog10() {
        this.testRescale(new Float[]{Float.valueOf(0.1f)}, 11.0, 1.0, ReinterpretDescriptor.LOGARITHMIC, ReinterpretDescriptor.AWT, 4, Math.log10(2.1));
    }

    @Test
    public void testRescaleByteExp10() {
        this.testRescale(new Byte[]{(byte)-1}, 0.00392156862745098, 1.0, ReinterpretDescriptor.EXPONENTIAL, ReinterpretDescriptor.AWT, 4, Math.pow(10.0, 2.0));
        this.testRescale(new Byte[]{(byte)-1}, 0.00392156862745098, 1.0, ReinterpretDescriptor.EXPONENTIAL, ReinterpretDescriptor.INTERPRET_BYTE_SIGNED, 4, Math.pow(10.0, 0.996078431372549));
    }

    @Test
    public void testRescaleByteLog10() {
        this.testRescale(new Byte[]{(byte)-1}, 0.00392156862745098, 1.0, ReinterpretDescriptor.LOGARITHMIC, ReinterpretDescriptor.AWT, 4, Math.log10(2.0));
        this.testRescale(new Byte[]{(byte)-1}, 0.00392156862745098, 1.0, ReinterpretDescriptor.LOGARITHMIC, ReinterpretDescriptor.INTERPRET_BYTE_SIGNED, 4, Math.log10(0.996078431372549));
    }

    private void testRescale(Number[] sourcePixelValue, double factor, double offset, ScalingType scalingType, InterpretationType interpretationType, int expectedDataType, double expectedPixelValue) {
        RenderedImage target = ReinterpretOpImage.create((RenderedImage)ReinterpretOpImageTest.createSourceImage(sourcePixelValue), (double)factor, (double)offset, (ScalingType)scalingType, (InterpretationType)interpretationType, null);
        Assert.assertEquals((long)expectedDataType, (long)target.getSampleModel().getDataType());
        Raster targetData = target.getData();
        Assert.assertEquals((double)expectedPixelValue, (double)targetData.getSampleDouble(0, 0, 0), (double)(expectedDataType == 5 ? 1.0E-10 : 1.0E-5));
    }

    @Test
    @Ignore
    public void testScalingTypePerformance() {
        this.testScalingTypePerformance(ReinterpretDescriptor.LINEAR);
        this.testScalingTypePerformance(ReinterpretDescriptor.EXPONENTIAL);
        this.testScalingTypePerformance(ReinterpretDescriptor.LOGARITHMIC);
    }

    private void testScalingTypePerformance(ScalingType scalingType) {
        int size = 2048;
        RenderedOp sourceImage = ConstantDescriptor.create((Float)Float.valueOf(size), (Float)Float.valueOf(size), (Number[])new Byte[]{(byte)1}, null);
        RenderedImage renderedImage = ReinterpretOpImage.create((RenderedImage)sourceImage, (double)1.1, (double)0.1, (ScalingType)scalingType, (InterpretationType)ReinterpretDescriptor.AWT, null);
        int n = 10;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            long t0 = System.currentTimeMillis();
            renderedImage.getData();
            long t1 = System.currentTimeMillis();
            sum += (double)(t1 - t0);
        }
        System.out.println(scalingType + ": " + sum / (double)n + " ms for " + size * size + " pixels");
    }

    @Test
    public void testImageLayout() {
        int w = 1121;
        int h = 2000;
        RenderedImage source = ReinterpretOpImageTest.createSourceImage(w, h, w, 64, new Integer[]{0});
        SampleModel sampleModel = source.getSampleModel().createCompatibleSampleModel(w, h);
        ImageLayout imageLayout = ReinterpretDescriptor.createTargetImageLayout((RenderedImage)source, (SampleModel)sampleModel);
        RenderedOp target = ReinterpretDescriptor.create((RenderedImage)source, (double)11.0, (double)1.0, (ScalingType)ReinterpretDescriptor.LINEAR, (InterpretationType)ReinterpretDescriptor.AWT, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
        Assert.assertEquals((long)w, (long)target.getWidth());
        Assert.assertEquals((long)h, (long)target.getHeight());
        Assert.assertEquals((long)w, (long)target.getTileWidth());
        Assert.assertEquals((long)64L, (long)target.getTileHeight());
    }

    static RenderedImage createSourceImage(Number[] v) {
        return ConstantDescriptor.create((Float)Float.valueOf(10.0f), (Float)Float.valueOf(10.0f), (Number[])v, null);
    }

    static RenderedImage createSourceImage(int w, int h, int tw, int th, Number[] v) {
        ImageLayout imageLayout = new ImageLayout(0, 0, w, h);
        imageLayout.setTileWidth(tw);
        imageLayout.setTileHeight(th);
        return ConstantDescriptor.create((Float)Float.valueOf(w), (Float)Float.valueOf(h), (Number[])v, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
    }
}

