/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.operator;

import com.bc.ceres.jai.operator.SourceImageFactory;
import com.bc.ceres.jai.operator.XmlDescriptor;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import javax.media.jai.RenderedOp;
import junit.framework.TestCase;

public class XmlDescriptorTest
extends TestCase {
    public void testInvalidArgs() throws URISyntaxException {
        try {
            XmlDescriptor.create((URI)new URI(""), null, null);
        }
        catch (IllegalArgumentException e) {
            XmlDescriptorTest.fail((String)("Unexpected: " + e));
        }
        try {
            XmlDescriptor.create(null, new HashMap(), null);
            XmlDescriptorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            XmlDescriptor.create(null, null, null);
            XmlDescriptorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSimple() throws URISyntaxException {
        this.testSimple(this.getResource("nested.jai.xml"));
        this.testSimple(this.getResource("flat.jai.xml"));
    }

    private void testSimple(URI uri) {
        HashMap<String, BufferedImage> configuration = new HashMap<String, BufferedImage>();
        configuration.put("source0", SourceImageFactory.createOneBandedUShortImage(2, 2, new short[]{1, 2, 3, 4}));
        RenderedOp op = XmlDescriptor.create((URI)uri, configuration, null);
        XmlDescriptorTest.assertNotNull((Object)op);
        Raster data = op.getData();
        XmlDescriptorTest.assertEquals((int)1, (int)data.getSampleModel().getDataType());
        XmlDescriptorTest.assertEquals((int)150, (int)data.getSample(0, 0, 0));
        XmlDescriptorTest.assertEquals((int)200, (int)data.getSample(1, 0, 0));
        XmlDescriptorTest.assertEquals((int)250, (int)data.getSample(0, 1, 0));
        XmlDescriptorTest.assertEquals((int)300, (int)data.getSample(1, 1, 0));
    }

    private URI getResource(String name) throws URISyntaxException {
        URL url = ((Object)((Object)this)).getClass().getResource(name);
        XmlDescriptorTest.assertNotNull((Object)url);
        return url.toURI();
    }
}

