/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.tilecache;

import com.bc.ceres.jai.tilecache.MemoryTile;
import com.bc.ceres.jai.tilecache.SwapSpace;
import com.bc.ceres.jai.tilecache.SwappingTileCache;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.HashMap;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;
import junit.framework.TestCase;

public class SwappingTileCacheTest
extends TestCase {
    public void testTileStoreRestore() {
        long tileSize = 262144L;
        TiledImage im0 = SwappingTileCacheTest.createImage(4, 4);
        SwapSpaceMock swapSpaceMock = new SwapSpaceMock();
        SwappingTileCache cache = new SwappingTileCache(3L * tileSize + 1L, (SwapSpace)swapSpaceMock);
        Raster tile00 = im0.getTile(0, 0);
        Raster tile10 = im0.getTile(1, 0);
        Raster tile01 = im0.getTile(0, 1);
        Raster tile32 = im0.getTile(3, 2);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im0, 0, 0, tile00);
        SwappingTileCacheTest.assertEquals((String)"", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im0, 1, 0, tile10);
        SwappingTileCacheTest.assertEquals((String)"", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im0, 0, 1, tile01);
        SwappingTileCacheTest.assertEquals((String)"", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im0, 3, 2, tile32);
        SwappingTileCacheTest.assertEquals((String)"storeTile(0-0-0);storeTile(0-1-0);", (String)swapSpaceMock.trace);
        SwappingTileCacheTest.assertTrue((boolean)swapSpaceMock.containsTile((RenderedImage)im0, 0, 0));
        SwappingTileCacheTest.assertTrue((boolean)swapSpaceMock.containsTile((RenderedImage)im0, 1, 0));
        SwappingTileCacheTest.assertFalse((boolean)swapSpaceMock.containsTile((RenderedImage)im0, 0, 1));
        SwappingTileCacheTest.assertFalse((boolean)swapSpaceMock.containsTile((RenderedImage)im0, 3, 2));
        swapSpaceMock.trace = "";
        Raster tile00r = cache.getTile((RenderedImage)im0, 0, 0);
        SwappingTileCacheTest.assertEquals((String)"restoreTile(0-0-0)=MemoryTile;", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        Raster tile10r = cache.getTile((RenderedImage)im0, 1, 0);
        SwappingTileCacheTest.assertEquals((String)"restoreTile(0-1-0)=MemoryTile;storeTile(0-0-1);storeTile(0-3-2);", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        Raster tile01r = cache.getTile((RenderedImage)im0, 0, 1);
        SwappingTileCacheTest.assertEquals((String)"restoreTile(0-0-1)=MemoryTile;", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        Raster tile32r = cache.getTile((RenderedImage)im0, 3, 2);
        SwappingTileCacheTest.assertEquals((String)"restoreTile(0-3-2)=MemoryTile;storeTile(0-0-0);storeTile(0-1-0);", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        Raster tile33r = cache.getTile((RenderedImage)im0, 3, 3);
        SwappingTileCacheTest.assertEquals((String)"restoreTile(0-3-3)=null;", (String)swapSpaceMock.trace);
        this.testEqualTile(tile00, tile00r);
        this.testEqualTile(tile10, tile10r);
        this.testEqualTile(tile01, tile01r);
        this.testEqualTile(tile32, tile32r);
        SwappingTileCacheTest.assertNull((Object)tile33r);
        swapSpaceMock.trace = "";
        cache.remove((RenderedImage)im0, 0, 0);
        cache.remove((RenderedImage)im0, 0, 1);
        cache.remove((RenderedImage)im0, 2, 2);
        SwappingTileCacheTest.assertEquals((String)"deleteTile(0-0-0)=true;deleteTile(0-0-1)=true;deleteTile(0-2-2)=false;", (String)swapSpaceMock.trace);
        SwappingTileCacheTest.assertFalse((boolean)swapSpaceMock.containsTile((RenderedImage)im0, 0, 0));
        SwappingTileCacheTest.assertTrue((boolean)swapSpaceMock.containsTile((RenderedImage)im0, 1, 0));
        SwappingTileCacheTest.assertFalse((boolean)swapSpaceMock.containsTile((RenderedImage)im0, 0, 1));
        SwappingTileCacheTest.assertTrue((boolean)swapSpaceMock.containsTile((RenderedImage)im0, 3, 2));
        TiledImage im1 = SwappingTileCacheTest.createImage(4, 4);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im1, 0, 0, im1.getTile(0, 0));
        SwappingTileCacheTest.assertEquals((String)"", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im1, 0, 1, im1.getTile(0, 1));
        SwappingTileCacheTest.assertEquals((String)"", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im1, 0, 2, im1.getTile(0, 2));
        SwappingTileCacheTest.assertEquals((String)"storeTile(0-3-2);storeTile(1-0-0);", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im1, 0, 3, im1.getTile(0, 3));
        SwappingTileCacheTest.assertEquals((String)"", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im1, 1, 0, im1.getTile(1, 0));
        SwappingTileCacheTest.assertEquals((String)"storeTile(1-0-1);storeTile(1-0-2);", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im1, 1, 1, im1.getTile(1, 1));
        SwappingTileCacheTest.assertEquals((String)"", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.add((RenderedImage)im1, 1, 2, im1.getTile(1, 2));
        SwappingTileCacheTest.assertEquals((String)"storeTile(1-0-3);storeTile(1-1-0);", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.removeTiles((RenderedImage)im0);
        SwappingTileCacheTest.assertEquals((String)"deleteTile(0-0-0)=false;deleteTile(0-1-0)=true;deleteTile(0-2-0)=false;deleteTile(0-3-0)=false;deleteTile(0-0-1)=false;deleteTile(0-1-1)=false;deleteTile(0-2-1)=false;deleteTile(0-3-1)=false;deleteTile(0-0-2)=false;deleteTile(0-1-2)=false;deleteTile(0-2-2)=false;deleteTile(0-3-2)=true;deleteTile(0-0-3)=false;deleteTile(0-1-3)=false;deleteTile(0-2-3)=false;deleteTile(0-3-3)=false;", (String)swapSpaceMock.trace);
        swapSpaceMock.trace = "";
        cache.removeTiles((RenderedImage)im1);
        SwappingTileCacheTest.assertEquals((String)"deleteTile(1-0-0)=true;deleteTile(1-1-0)=true;deleteTile(1-2-0)=false;deleteTile(1-3-0)=false;deleteTile(1-0-1)=true;deleteTile(1-1-1)=false;deleteTile(1-2-1)=false;deleteTile(1-3-1)=false;deleteTile(1-0-2)=true;deleteTile(1-1-2)=false;deleteTile(1-2-2)=false;deleteTile(1-3-2)=false;deleteTile(1-0-3)=true;deleteTile(1-1-3)=false;deleteTile(1-2-3)=false;deleteTile(1-3-3)=false;", (String)swapSpaceMock.trace);
    }

    private static TiledImage createImage(int numXTiles, int numYTiles) {
        ComponentSampleModelJAI sm = new ComponentSampleModelJAI(4, 256, 256, 1, 256, new int[1]);
        return new TiledImage(0, 0, numXTiles * 256, numYTiles * 256, 0, 0, (SampleModel)sm, PlanarImage.createColorModel((SampleModel)sm));
    }

    private void testEqualTile(Raster tile00, Raster tile00r) {
        SwappingTileCacheTest.assertNotNull((Object)tile00);
        SwappingTileCacheTest.assertNotNull((Object)tile00r);
        SwappingTileCacheTest.assertEquals((int)tile00.getWidth(), (int)tile00r.getWidth());
        SwappingTileCacheTest.assertEquals((int)tile00.getHeight(), (int)tile00r.getHeight());
        SwappingTileCacheTest.assertEquals((Object)tile00.getSampleModel(), (Object)tile00r.getSampleModel());
    }

    private static class SwapSpaceMock
    implements SwapSpace {
        HashMap<RenderedImage, Integer> ids = new HashMap();
        HashMap<String, MemoryTile> tiles = new HashMap();
        String trace = "";

        private SwapSpaceMock() {
        }

        public boolean containsTile(RenderedImage owner, int tileX, int tileY) {
            String key = this.getKey(owner, tileX, tileY);
            return this.tiles.containsKey(key);
        }

        public boolean storeTile(MemoryTile memoryTile) {
            String key = this.getKey(memoryTile.getOwner(), memoryTile.getTileX(), memoryTile.getTileY());
            this.tiles.put(key, memoryTile);
            this.trace = this.trace + "storeTile(" + key + ");";
            return true;
        }

        public MemoryTile restoreTile(RenderedImage owner, int tileX, int tileY) {
            String key = this.getKey(owner, tileX, tileY);
            MemoryTile memoryTile = this.tiles.get(key);
            this.trace = this.trace + "restoreTile(" + key + ")=" + (memoryTile != null ? "MemoryTile" : "null") + ";";
            return memoryTile;
        }

        public boolean deleteTile(RenderedImage owner, int tileX, int tileY) {
            String key = this.getKey(owner, tileX, tileY);
            boolean b = this.tiles.remove(key) != null;
            this.trace = this.trace + "deleteTile(" + key + ")=" + b + ";";
            return b;
        }

        private int getId(RenderedImage owner) {
            Integer integer = this.ids.get(owner);
            if (integer != null) {
                return integer;
            }
            integer = this.ids.size();
            this.ids.put(owner, integer);
            return integer;
        }

        private String getKey(RenderedImage owner, int tileX, int tileY) {
            return this.getId(owner) + "-" + tileX + "-" + tileY;
        }
    }
}

