/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.opimage;

import com.bc.ceres.compiler.Code;
import com.bc.ceres.jai.operator.ExpressionDescriptorTest;
import com.bc.ceres.jai.opimage.ExpressionCode;
import com.bc.ceres.jai.opimage.ExpressionCodeGenerator;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.TestCase;

public class ExpressionCodeGeneratorTest
extends TestCase {
    public void testGeneratedCode() {
        HashMap<String, RenderedImage> sourceMap = ExpressionDescriptorTest.createSourceMap();
        ExpressionCode code = ExpressionCodeGenerator.generate((String)"com.bc.ceres.jai.opimage", (String)"ExpressionOpImage_1", sourceMap, (int)5, (String)"S1 * S2 / S3 % S4 + S5 - S6");
        ExpressionCodeGeneratorTest.assertNotNull((Object)code);
        ExpressionCodeGeneratorTest.assertEquals((String)"com.bc.ceres.jai.opimage.ExpressionOpImage_1", (String)code.getClassName());
        ExpressionCodeGeneratorTest.assertNotNull((Object)code.getSources());
        ExpressionCodeGeneratorTest.assertEquals((int)6, (int)code.getSources().size());
        ExpressionCodeGeneratorTest.assertNotNull((Object)code.getCharContent(true));
        ExpressionCodeGeneratorTest.assertTrue((code.getCharContent(true).length() > 0 ? 1 : 0) != 0);
        ExpressionCodeGeneratorTest.write((Code)code);
    }

    static void write(Code code) {
        try {
            File file = new File("./src/test/java/" + code.getClassName().replace('.', '/') + ".java");
            file.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(file);
            String source = code.getCharContent(true).toString();
            writer.write(source);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            ExpressionCodeGeneratorTest.fail();
        }
    }
}

