/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.operator;

import com.bc.ceres.jai.operator.PaintDescriptor;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PaintDescriptorTest {
    private BufferedImage source0rgb;
    private BufferedImage source0rgba;
    private BufferedImage source1;

    @Before
    public void setUp() throws Exception {
        this.source0rgb = new BufferedImage(2, 2, 5);
        WritableRaster source0rgbData = this.source0rgb.getWritableTile(0, 0);
        source0rgbData.setPixel(0, 0, new int[]{255, 255, 255});
        source0rgbData.setPixel(1, 0, new int[]{255, 255, 255});
        source0rgbData.setPixel(0, 1, new int[]{255, 255, 255});
        source0rgbData.setPixel(1, 1, new int[]{255, 255, 255});
        this.source0rgba = new BufferedImage(2, 2, 6);
        WritableRaster source0rgbaData = this.source0rgba.getWritableTile(0, 0);
        source0rgbaData.setPixel(0, 0, new int[]{255, 255, 255, 103});
        source0rgbaData.setPixel(1, 0, new int[]{255, 255, 255, 255});
        source0rgbaData.setPixel(0, 1, new int[]{255, 255, 255, 255});
        source0rgbaData.setPixel(1, 1, new int[]{255, 255, 255, 255});
        this.source1 = new BufferedImage(2, 2, 10);
        WritableRaster source1Data = this.source1.getWritableTile(0, 0);
        source1Data.setSample(0, 0, 0, 255);
        source1Data.setSample(1, 0, 0, 0);
        source1Data.setSample(0, 1, 0, 0);
        source1Data.setSample(1, 1, 0, 127);
    }

    @Test
    public void testImagePropertiesFromRGBWithOpaquePaint() {
        this.testImageProperties(3, this.source0rgb, new Color(255, 0, 0));
    }

    @Test
    public void testImagePropertiesFromRGBAWithOpaquePaint() {
        this.testImageProperties(4, this.source0rgba, new Color(255, 0, 0));
    }

    @Test
    public void testImagePropertiesFromRGBWithAlphaPaint() {
        this.testImageProperties(4, this.source0rgb, new Color(255, 0, 0, 127));
    }

    @Test
    public void testImagePropertiesFromRGBAWithAlphaPaint() {
        this.testImageProperties(4, this.source0rgba, new Color(255, 0, 0, 127));
    }

    @Test
    public void testRgbPaintOpaqueRed() {
        Color paintColor = new Color(255, 0, 0);
        RenderedOp paintedImage = PaintDescriptor.create((RenderedImage)this.source0rgb, (RenderedImage)this.source1, (Color)paintColor, (Boolean)false, null);
        Assert.assertNotNull((Object)paintedImage);
        Raster destData = paintedImage.getData();
        Assert.assertArrayEquals((int[])new int[]{255, 255, 255}, (int[])destData.getPixel(0, 0, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0}, (int[])destData.getPixel(1, 0, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0}, (int[])destData.getPixel(0, 1, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{255, 127, 127}, (int[])destData.getPixel(1, 1, (int[])null));
    }

    @Test
    public void testRgbaPaintOpaqueRed() {
        Color paintColor = new Color(255, 0, 0);
        RenderedOp paintedImage = PaintDescriptor.create((RenderedImage)this.source0rgba, (RenderedImage)this.source1, (Color)paintColor, (Boolean)false, null);
        Assert.assertNotNull((Object)paintedImage);
        Raster destData = paintedImage.getData();
        Assert.assertArrayEquals((int[])new int[]{255, 255, 255, 103}, (int[])destData.getPixel(0, 0, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0, 255}, (int[])destData.getPixel(1, 0, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0, 255}, (int[])destData.getPixel(0, 1, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{255, 127, 127, 255}, (int[])destData.getPixel(1, 1, (int[])null));
    }

    @Test
    public void testRgbaPaintSemiTransparentRed() {
        Color paintColor = new Color(255, 0, 0, 127);
        RenderedOp paintedImage = PaintDescriptor.create((RenderedImage)this.source0rgba, (RenderedImage)this.source1, (Color)paintColor, (Boolean)false, null);
        Assert.assertNotNull((Object)paintedImage);
        Raster destData = paintedImage.getData();
        Assert.assertArrayEquals((int[])new int[]{255, 255, 255, 103}, (int[])destData.getPixel(0, 0, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0, 127}, (int[])destData.getPixel(1, 0, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{255, 0, 0, 127}, (int[])destData.getPixel(0, 1, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{255, 127, 127, 190}, (int[])destData.getPixel(1, 1, (int[])null));
    }

    @Test
    public void testRgbaPaintFullyTransparentColor() {
        Color paintColor = new Color(0, 0, 0, 0);
        RenderedOp paintedImage = PaintDescriptor.create((RenderedImage)this.source0rgba, (RenderedImage)this.source1, (Color)paintColor, (Boolean)false, null);
        Assert.assertNotNull((Object)paintedImage);
        Raster destData = paintedImage.getData();
        Assert.assertArrayEquals((int[])new int[]{255, 255, 255, 103}, (int[])destData.getPixel(0, 0, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0, 0}, (int[])destData.getPixel(1, 0, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0, 0}, (int[])destData.getPixel(0, 1, (int[])null));
        Assert.assertArrayEquals((int[])new int[]{127, 127, 127, 127}, (int[])destData.getPixel(1, 1, (int[])null));
    }

    private void testImageProperties(int expectedNumBands, BufferedImage sourceImage, Color paintColor) {
        RenderedOp paintedImage = PaintDescriptor.create((RenderedImage)sourceImage, (RenderedImage)this.source1, (Color)paintColor, (Boolean)false, null);
        Assert.assertNotNull((Object)paintedImage);
        Assert.assertEquals((long)0L, (long)paintedImage.getSampleModel().getDataType());
        Assert.assertEquals((long)expectedNumBands, (long)paintedImage.getSampleModel().getNumBands());
        Assert.assertEquals((long)2L, (long)paintedImage.getWidth());
        Assert.assertEquals((long)2L, (long)paintedImage.getHeight());
    }
}

