/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.operator;

import com.bc.ceres.jai.GeneralFilterFunction;
import com.bc.ceres.jai.operator.GeneralFilterDescriptor;
import java.awt.RenderingHints;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.util.Timer;
import java.util.TimerTask;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class GameOfLifeTestMain {
    private static final int IMAGE_UPDATE_PERIOD = 30;
    private JLabel label;
    private BufferedImage image;
    private JFrame frame;

    public static void main(String[] args) {
        new GameOfLifeTestMain().run();
    }

    public void run() {
        this.image = new BufferedImage(512, 512, 10);
        byte[] bytes = ((DataBufferByte)this.image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(Math.random() < 0.5 ? 0 : 255);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GameOfLifeTestMain.this.label = new JLabel(new ImageIcon(GameOfLifeTestMain.this.image));
                GameOfLifeTestMain.this.frame = new JFrame("GoL");
                GameOfLifeTestMain.this.frame.getContentPane().add(GameOfLifeTestMain.this.label);
                GameOfLifeTestMain.this.frame.pack();
                GameOfLifeTestMain.this.frame.setDefaultCloseOperation(3);
                GameOfLifeTestMain.this.frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                        Timer timer = new Timer();
                        timer.schedule((TimerTask)new MyTimerTask(), 1000L, 30L);
                    }
                });
                GameOfLifeTestMain.this.frame.setVisible(true);
            }
        });
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        @Override
        public void run() {
            RenderedOp op = GeneralFilterDescriptor.create((RenderedImage)GameOfLifeTestMain.this.image, (GeneralFilterFunction)new GoLFilterFunction(), (RenderingHints)new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)3)));
            GameOfLifeTestMain.this.image = op.getAsBufferedImage();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GameOfLifeTestMain.this.label.setIcon(new ImageIcon(GameOfLifeTestMain.this.image));
                }
            });
        }
    }

    private static class GoLFilterFunction
    extends GeneralFilterFunction {
        private GoLFilterFunction() {
            super(3, 3, 1, 1, null);
        }

        public float filter(float[] fdata) {
            int n = 0;
            for (int i = 0; i < 9; ++i) {
                if (i == 4 || fdata[i] == 0.0f) continue;
                ++n;
            }
            if ((double)fdata[4] > 0.0) {
                return n == 2 || n == 3 ? 255.0f : 0.0f;
            }
            return n == 3 ? 255.0f : 0.0f;
        }
    }
}

