/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai.operator;

import com.bc.ceres.jai.ExpressionCompilerConfig;
import com.bc.ceres.jai.opimage.ExpressionCRIF;
import com.bc.ceres.jai.opimage.ExpressionOpImage_1;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import junit.framework.TestCase;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class ExpressionDescriptorTest
extends TestCase {
    private static final String M2REPO;
    private static final int W = 4;
    private static final int H = 5;
    private static final byte S1 = -45;
    private static final short S2 = -2198;
    private static final short S3 = 23753;
    private static final int S4 = 83457;
    private static final float S5 = 5.1f;
    private static final double S6 = 6.4;
    private static final double N3 = -3.6;
    private static final float N2 = 2.7f;
    private static final int N1 = 32;

    public void testDescriptor() {
        ParameterBlockJAI params = ExpressionDescriptorTest.createParameterBlock(5, "S1 * S2 / S3 % S4 + S5 - S6");
        RenderedOp op = JAI.create((String)"Expression", (ParameterBlock)params, null);
        ExpressionDescriptorTest.testDestinationImage((RenderedImage)op, 2.700000381469726);
        params = ExpressionDescriptorTest.createParameterBlock(3, "S1 * S2 / S3 - S4");
        op = JAI.create((String)"Expression", (ParameterBlock)params, null);
        ExpressionDescriptorTest.testDestinationImage((RenderedImage)op, -83453);
        params = ExpressionDescriptorTest.createParameterBlock(4, "sqrt(S5)");
        op = JAI.create((String)"Expression", (ParameterBlock)params, null);
        ExpressionDescriptorTest.testDestinationImage((RenderedImage)op, (float)Math.sqrt(5.1f));
    }

    public void testCRIF() {
        ParameterBlockJAI params = ExpressionDescriptorTest.createParameterBlock(5, "S1 * S2 / S3 % S4 + S5 - S6");
        ExpressionCRIF crif = new ExpressionCRIF();
        RenderedImage image = crif.create((ParameterBlock)params, null);
        ExpressionDescriptorTest.testDestinationImage(image, 2.700000381469726);
    }

    public void testGeneratedExpressionOpImage() {
        HashMap<String, RenderedImage> sourceMap = ExpressionDescriptorTest.createSourceMap();
        Vector<RenderedImage> sources = new Vector<RenderedImage>();
        sources.add(sourceMap.get("S1"));
        sources.add(sourceMap.get("S2"));
        sources.add(sourceMap.get("S3"));
        sources.add(sourceMap.get("S4"));
        sources.add(sourceMap.get("S5"));
        sources.add(sourceMap.get("S6"));
        ExpressionOpImage_1 opImage = new ExpressionOpImage_1(sources, null, ExpressionDescriptorTest.createImageLayout());
        ExpressionDescriptorTest.testDestinationImage((RenderedImage)((Object)opImage), 2.700000381469726);
    }

    static ExpressionCompilerConfig createExpressionCompilerConfig() {
        File m2repo = new File(M2REPO);
        if (!m2repo.exists()) {
            ExpressionDescriptorTest.fail((String)("Maven2 repository not found at " + m2repo + ".\nPlease adjust system property 'm2repo'."));
        }
        File outputDir = new File("./target/test-classes");
        File[] classPath = new File[]{new File(m2repo, "javax/media/jai/jai-core/1.1.3/jai-core-1.1.3.jar"), new File(m2repo, "javax/media/jai/jai-codec/1.1.3/jai-codec-1.1.3.jar"), new File("./target/classes"), new File("./target/test-classes")};
        return new ExpressionCompilerConfig(outputDir, classPath);
    }

    private static ParameterBlockJAI createParameterBlock(int dataType, String expression) {
        ParameterBlockJAI args = new ParameterBlockJAI("Expression");
        args.addSource(ExpressionDescriptorTest.createSourceMap());
        args.setParameter("dataType", dataType);
        args.setParameter("expression", (Object)expression);
        args.setParameter("compilerConfig", (Object)ExpressionDescriptorTest.createExpressionCompilerConfig());
        return args;
    }

    public static HashMap<String, RenderedImage> createSourceMap() {
        HashMap<String, RenderedImage> map = new HashMap<String, RenderedImage>();
        map.put("S1", (RenderedImage)ExpressionDescriptorTest.createSourceImage(new Byte[]{(byte)-45}));
        map.put("S2", (RenderedImage)ExpressionDescriptorTest.createSourceImage(new Short[]{(short)-2198}));
        map.put("S3", (RenderedImage)ExpressionDescriptorTest.createSourceImage(new Short[]{(short)23753}));
        map.put("S4", (RenderedImage)ExpressionDescriptorTest.createSourceImage(new Integer[]{83457}));
        map.put("S5", (RenderedImage)ExpressionDescriptorTest.createSourceImage(new Float[]{Float.valueOf(5.1f)}));
        map.put("S6", (RenderedImage)ExpressionDescriptorTest.createSourceImage(new Double[]{6.4}));
        return map;
    }

    static HashMap<String, Number> createConstantMap() {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("N1", 32);
        map.put("N2", Float.valueOf(2.7f));
        map.put("N3", -3.6);
        return map;
    }

    static HashMap<String, Map<String, Integer>> createMaskMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("F1", 1);
        map.put("F2", 64);
        HashMap<String, Map<String, Integer>> map2 = new HashMap<String, Map<String, Integer>>();
        map2.put("S4", map);
        return map2;
    }

    private static void testDestinationImage(RenderedImage image, double expectedSample) {
        ExpressionDescriptorTest.assertNotNull((Object)image);
        ExpressionDescriptorTest.assertEquals((int)4, (int)image.getWidth());
        ExpressionDescriptorTest.assertEquals((int)5, (int)image.getHeight());
        Raster data = image.getData();
        ExpressionDescriptorTest.assertEquals((double)expectedSample, (double)data.getSampleDouble(0, 0, 0), (double)1.0E-10);
        ExpressionDescriptorTest.assertEquals((double)expectedSample, (double)data.getSampleDouble(1, 1, 0), (double)1.0E-10);
        ExpressionDescriptorTest.assertEquals((double)expectedSample, (double)data.getSampleDouble(2, 2, 0), (double)1.0E-10);
        ExpressionDescriptorTest.assertEquals((double)expectedSample, (double)data.getSampleDouble(3, 3, 0), (double)1.0E-10);
    }

    private static void testDestinationImage(RenderedImage image, int expectedSample) {
        ExpressionDescriptorTest.assertNotNull((Object)image);
        ExpressionDescriptorTest.assertEquals((int)4, (int)image.getWidth());
        ExpressionDescriptorTest.assertEquals((int)5, (int)image.getHeight());
        Raster data = image.getData();
        ExpressionDescriptorTest.assertEquals((int)expectedSample, (int)data.getSample(0, 0, 0));
        ExpressionDescriptorTest.assertEquals((int)expectedSample, (int)data.getSample(1, 1, 0));
        ExpressionDescriptorTest.assertEquals((int)expectedSample, (int)data.getSample(2, 2, 0));
        ExpressionDescriptorTest.assertEquals((int)expectedSample, (int)data.getSample(3, 3, 0));
    }

    static RenderedOp createSourceImage(Number[] v) {
        return ConstantDescriptor.create((Float)Float.valueOf(4.0f), (Float)Float.valueOf(5.0f), (Number[])v, null);
    }

    static ImageLayout createImageLayout() {
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setWidth(4);
        imageLayout.setHeight(5);
        imageLayout.setSampleModel((SampleModel)new PixelInterleavedSampleModel(5, 4, 5, 1, 4, new int[]{0}));
        return imageLayout;
    }

    static {
        String localRepositoryPath = System.getProperty("m2repo");
        if (localRepositoryPath == null) {
            String settingsFile = new File(System.getProperty("user.home"), ".m2/settings.xml").getPath();
            try {
                Document document = new SAXBuilder().build(settingsFile);
                localRepositoryPath = document.getRootElement().getChildText("localRepository");
            }
            catch (JDOMException jDOMException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (localRepositoryPath == null) {
                localRepositoryPath = new File(System.getProperty("user.home"), ".m2/repository").getPath();
            }
        }
        M2REPO = localRepositoryPath;
    }
}

