/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.WarpPolynomial;
import javax.media.jai.operator.FileLoadDescriptor;
import javax.media.jai.operator.FileStoreDescriptor;
import javax.media.jai.operator.WarpDescriptor;

public class WarpTestMain {
    public static void main(String[] args) {
        String sourceFile = args[0];
        String targetFile = args[1];
        String format = targetFile.substring(1 + targetFile.lastIndexOf(46));
        Interpolation interpolation = Interpolation.getInstance((int)0);
        double backgroundValue = 255.0;
        RenderedOp source = FileLoadDescriptor.create((String)sourceFile, null, (Boolean)true, null);
        double[] background = new double[source.getNumBands()];
        Arrays.fill(background, backgroundValue);
        int w = source.getWidth();
        int h = source.getHeight();
        float[] sourceCoords = new float[2 * w * h];
        int n = 0;
        int step = 32;
        for (int y = 0; y < h; y += 32) {
            for (int x = 0; x < w; x += 32) {
                sourceCoords[2 * n] = x;
                sourceCoords[2 * n + 1] = y;
                ++n;
            }
        }
        float[] targetCoords = new TExp(w, h).t(sourceCoords);
        WarpPolynomial warp = WarpPolynomial.createWarp((float[])sourceCoords, (int)0, (float[])targetCoords, (int)0, (int)n, (float)(1.0f / (float)w), (float)(1.0f / (float)h), (float)w, (float)h, (int)3);
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setWidth(w);
        imageLayout.setHeight(h);
        RenderingHints renderingHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        RenderedOp target = WarpDescriptor.create((RenderedImage)source, (Warp)warp, (Interpolation)interpolation, (double[])background, (RenderingHints)renderingHints);
        FileStoreDescriptor.create((RenderedImage)target, (String)targetFile, (String)format, null, (Boolean)false, null);
    }

    static class TExp
    implements T {
        final int w;
        final int h;

        TExp(int w, int h) {
            this.w = w;
            this.h = h;
        }

        @Override
        public float[] t(float[] a) {
            float[] b = new float[a.length];
            float s = 1.0f / (float)Math.sqrt((float)this.w * (float)this.w + (float)this.h * (float)this.h);
            s *= s;
            for (int i = 0; i < a.length; i += 2) {
                float x = a[i];
                float y = a[i + 1];
                float dx = x - 0.5f * (float)this.w;
                float dy = y - 0.5f * (float)this.h;
                float v = (float)Math.sqrt(dx * dx + dy * dy);
                v = s * (v * v);
                float xx = 0.5f * (float)this.w + v * dx;
                float yy = 0.5f * (float)this.h + v * dy;
                System.out.println("(" + x + "," + y + ") --> (" + yy + "," + yy + ")");
                b[i] = xx;
                b[i + 1] = yy;
            }
            return b;
        }
    }

    static interface T {
        public float[] t(float[] var1);
    }
}

