/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai;

import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.SourcelessOpImage;
import junit.framework.TestCase;

public class TileTest
extends TestCase {
    public void testTilesHaveExpectedBounds() {
        int imageSize = 100;
        int tileSize = 50;
        Opi image = new Opi(0, 0, imageSize, imageSize, 0, 0, tileSize, tileSize);
        TileTest.assertEquals((int)0, (int)image.getTileGridXOffset());
        TileTest.assertEquals((int)2, (int)image.getNumXTiles());
        TileTest.assertEquals((int)0, (int)image.getMinTileX());
        TileTest.assertEquals((int)1, (int)image.getMaxTileX());
        TileTest.assertEquals((int)0, (int)image.tileXToX(0));
        TileTest.assertEquals((int)50, (int)image.tileXToX(1));
        TileTest.assertOutOfBounds(image, new Rectangle(-1, 0, 1, 1));
        TileTest.assertWithinBounds(image, new Rectangle(0, 0, 1, 1), "(0,0,50,50),(0,0,50,50);");
        TileTest.assertWithinBounds(image, new Rectangle(50, 0, 1, 1), "(50,0,50,50),(50,0,50,50);");
        TileTest.assertOutOfBounds(image, new Rectangle(100, 0, 1, 1));
        image = new Opi(-20, 0, imageSize, imageSize, 0, 0, tileSize, tileSize);
        TileTest.assertEquals((int)0, (int)image.getTileGridXOffset());
        TileTest.assertEquals((int)3, (int)image.getNumXTiles());
        TileTest.assertEquals((int)-1, (int)image.getMinTileX());
        TileTest.assertEquals((int)1, (int)image.getMaxTileX());
        TileTest.assertEquals((int)-50, (int)image.tileXToX(-1));
        TileTest.assertEquals((int)0, (int)image.tileXToX(0));
        TileTest.assertEquals((int)50, (int)image.tileXToX(1));
        TileTest.assertOutOfBounds(image, new Rectangle(-21, 0, 1, 1));
        TileTest.assertWithinBounds(image, new Rectangle(-20, 0, 1, 1), "(-50,0,50,50),(-20,0,20,50);");
        TileTest.assertWithinBounds(image, new Rectangle(0, 0, 1, 1), "(0,0,50,50),(0,0,50,50);");
        TileTest.assertWithinBounds(image, new Rectangle(50, 0, 1, 1), "(50,0,50,50),(50,0,30,50);");
        TileTest.assertOutOfBounds(image, new Rectangle(80, 0, 1, 1));
        image = new Opi(0, 0, imageSize, imageSize, -15, 0, tileSize, tileSize);
        TileTest.assertEquals((int)-15, (int)image.getTileGridXOffset());
        TileTest.assertEquals((int)3, (int)image.getNumXTiles());
        TileTest.assertEquals((int)0, (int)image.getMinTileX());
        TileTest.assertEquals((int)2, (int)image.getMaxTileX());
        TileTest.assertEquals((int)-15, (int)image.tileXToX(0));
        TileTest.assertEquals((int)35, (int)image.tileXToX(1));
        TileTest.assertEquals((int)85, (int)image.tileXToX(2));
        TileTest.assertOutOfBounds(image, new Rectangle(-15, 0, 1, 1));
        TileTest.assertWithinBounds(image, new Rectangle(0, 0, 1, 1), "(-15,0,50,50),(0,0,35,50);");
        TileTest.assertWithinBounds(image, new Rectangle(50, 0, 1, 1), "(35,0,50,50),(35,0,50,50);");
        TileTest.assertWithinBounds(image, new Rectangle(99, 0, 1, 1), "(85,0,50,50),(85,0,15,50);");
        TileTest.assertOutOfBounds(image, new Rectangle(100, 0, 1, 1));
        image = new Opi(-20, 0, imageSize, imageSize, -15, 0, tileSize, tileSize);
        TileTest.assertEquals((int)-15, (int)image.getTileGridXOffset());
        TileTest.assertEquals((int)3, (int)image.getNumXTiles());
        TileTest.assertEquals((int)-1, (int)image.getMinTileX());
        TileTest.assertEquals((int)1, (int)image.getMaxTileX());
        TileTest.assertEquals((int)-15, (int)image.tileXToX(0));
        TileTest.assertEquals((int)35, (int)image.tileXToX(1));
        TileTest.assertEquals((int)85, (int)image.tileXToX(2));
        TileTest.assertOutOfBounds(image, new Rectangle(-21, 0, 1, 1));
        TileTest.assertWithinBounds(image, new Rectangle(-20, 0, 1, 1), "(-65,0,50,50),(-20,0,5,50);");
        TileTest.assertWithinBounds(image, new Rectangle(0, 0, 1, 1), "(-15,0,50,50),(-15,0,50,50);");
        TileTest.assertWithinBounds(image, new Rectangle(50, 0, 1, 1), "(35,0,50,50),(35,0,45,50);");
        TileTest.assertOutOfBounds(image, new Rectangle(80, 0, 1, 1));
    }

    private static void assertOutOfBounds(Opi image, Rectangle region) {
        try {
            image.getData(region);
            TileTest.fail((String)("The specified region " + TileTest.rstring(region) + " should not intersect with the image`s bounds " + TileTest.rstring(image.getBounds())));
        }
        catch (IllegalArgumentException e) {
            TileTest.assertEquals((String)"The specified region, if not null, must intersect with the image`s bounds.", (String)e.getMessage());
        }
    }

    private static void assertWithinBounds(Opi image, Rectangle input, String expected) {
        image.trace = "";
        image.getData(input);
        TileTest.assertEquals((String)expected, (String)image.trace);
    }

    private static String rstring(Rectangle rectangle) {
        return "(" + rectangle.x + "," + rectangle.y + "," + rectangle.width + "," + rectangle.height + ")";
    }

    static class Opi
    extends SourcelessOpImage {
        String trace = "";

        Opi(int minX, int minY, int width, int height, int tileGridXOffset, int tileGridYOffset, int tileWidth, int tileHeight) {
            super(new ImageLayout(minX, minY, width, height, tileGridXOffset, tileGridYOffset, tileWidth, tileHeight, null, null), null, (SampleModel)new ComponentSampleModel(0, width, height, 1, width, new int[]{0}), minX, minY, width, height);
        }

        protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
            this.trace = this.trace + TileTest.rstring(dest.getBounds()) + "," + TileTest.rstring(destRect) + ";";
        }
    }
}

