/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.jai;

import com.bc.ceres.jai.DFTTestMain;
import com.bc.ceres.jai.operator.DFTConvolveDescriptor;
import com.bc.ceres.jai.opimage.DFTConvolveRIF;
import com.bc.ceres.jai.tilecache.DefaultSwapSpace;
import com.bc.ceres.jai.tilecache.SwapSpace;
import com.bc.ceres.jai.tilecache.SwappingTileCache;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.JAI;
import javax.media.jai.KernelJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.operator.ConvolveDescriptor;
import javax.media.jai.operator.FileLoadDescriptor;
import javax.media.jai.operator.MultiplyConstDescriptor;
import javax.media.jai.operator.SubtractDescriptor;

public class DFTConvolveTestMain {
    private static final long M = 0x100000L;

    public static void main(String[] args) {
        File swapDir = new File("swap");
        swapDir.mkdir();
        Logger logger = Logger.getAnonymousLogger();
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        logger.addHandler(consoleHandler);
        logger.setLevel(Level.ALL);
        DefaultSwapSpace swapSpace = new DefaultSwapSpace(swapDir, logger);
        SwappingTileCache tileCache = new SwappingTileCache(0x4000000L, (SwapSpace)swapSpace);
        JAI.getDefaultInstance().setTileCache((TileCache)tileCache);
        RenderedImage sourceImage = args.length == 0 ? DFTTestMain.createTestImage(512, 512) : FileLoadDescriptor.create((String)args[0], null, (Boolean)false, null);
        sourceImage = DFTConvolveRIF.toFloat((RenderedImage)sourceImage, null);
        BorderExtender extender = BorderExtender.createInstance((int)1);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender);
        KernelJAI kernel = DFTConvolveTestMain.createBlurrKernel(33);
        RenderedOp convolvedImage = ConvolveDescriptor.create((RenderedImage)sourceImage, (KernelJAI)kernel, (RenderingHints)hints);
        RenderedOp dftConvolvedImage = DFTConvolveDescriptor.create((RenderedImage)sourceImage, (KernelJAI)kernel, null, (RenderingHints)hints);
        RenderedOp deltaImage = MultiplyConstDescriptor.create((RenderedImage)SubtractDescriptor.create((RenderedImage)convolvedImage, (RenderedImage)dftConvolvedImage, null), (double[])new double[]{2.0}, null);
        DFTTestMain.showImage(sourceImage, "sourceImage");
        DFTTestMain.showImage((RenderedImage)convolvedImage, "convolvedImage");
        DFTTestMain.showImage((RenderedImage)dftConvolvedImage, "dftConvolvedImage");
        DFTTestMain.showImage((RenderedImage)deltaImage, "deltaImage");
        Object o = dftConvolvedImage.getProperty("kernelFT");
        System.out.println("o = " + o);
        System.out.println("Kernel\tConvolve\tDFTConvolve\tPerfGain");
        for (int i = 3; i <= 201; i += 2) {
            KernelJAI k = DFTConvolveTestMain.createBlurrKernel(i);
            double t1 = DFTConvolveTestMain.getRenderTime(ConvolveDescriptor.create((RenderedImage)sourceImage, (KernelJAI)k, (RenderingHints)hints));
            double t2 = DFTConvolveTestMain.getRenderTime(DFTConvolveDescriptor.create((RenderedImage)sourceImage, (KernelJAI)k, null, (RenderingHints)hints));
            System.out.println(i + "\t" + t1 + "\t" + t2 + "\t" + t1 / t2);
        }
    }

    private static double getRenderTime(RenderedOp op) {
        long t0 = System.nanoTime();
        op.getAsBufferedImage();
        long t1 = System.nanoTime();
        return (double)(t1 - t0) / 1000000.0;
    }

    private static KernelJAI createBlurrKernel(int size) {
        int i;
        float[] data = new float[size * size];
        for (int j = 0; j < size; ++j) {
            for (i = 0; i < size; ++i) {
                float dx = (float)i / ((float)size - 1.0f) - 0.5f;
                float dy = (float)j / ((float)size - 1.0f) - 0.5f;
                float v = 1.0f - (float)Math.sqrt(dx * dx + dy * dy);
                data[j * size + i] = v < 0.0f ? 0.0f : v;
            }
        }
        float sum = 0.0f;
        for (i = 0; i < data.length; ++i) {
            sum += data[i];
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / sum;
        }
        return new KernelJAI(size, size, data);
    }

    private static KernelJAI createIdentityKernel(int size) {
        float[] data = new float[size * size];
        data[size / 2 * size + size / 2] = 1.0f;
        return new KernelJAI(size, size, data);
    }
}

