/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.ConstantDescriptor;
import org.junit.Assert;
import org.junit.Test;

public class DefaultMultiLevelSourceTest {
    @Test
    public void testScaledImageSizes1() throws Exception {
        int W = 4096;
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(6, new AffineTransform(), (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, W, W));
        DefaultMultiLevelSource source = new DefaultMultiLevelSource((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(W), (Float)Float.valueOf(W), (Number[])new Byte[]{(byte)0}, null), (MultiLevelModel)model);
        this.testScaledImageSizes(4096, 0, source);
        this.testScaledImageSizes(2048, 1, source);
        this.testScaledImageSizes(1024, 2, source);
        this.testScaledImageSizes(512, 3, source);
        this.testScaledImageSizes(256, 4, source);
        this.testScaledImageSizes(128, 5, source);
    }

    @Test
    public void testScaledImageSizes2() throws Exception {
        int W = 1826;
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(6, new AffineTransform(), (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, W, W));
        DefaultMultiLevelSource source = new DefaultMultiLevelSource((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(W), (Float)Float.valueOf(W), (Number[])new Byte[]{(byte)0}, null), (MultiLevelModel)model);
        this.testScaledImageSizes(1826, 0, source);
        this.testScaledImageSizes(913, 1, source);
        this.testScaledImageSizes(457, 2, source);
        this.testScaledImageSizes(229, 3, source);
        this.testScaledImageSizes(115, 4, source);
        this.testScaledImageSizes(58, 5, source);
    }

    private void testScaledImageSizes(int expectedSize, int level, DefaultMultiLevelSource source) {
        Rectangle expectedRect = new Rectangle(0, 0, expectedSize, expectedSize);
        Rectangle sourceRect = new Rectangle(0, 0, source.getSourceImage().getWidth(), source.getSourceImage().getHeight());
        Rectangle j2kLevelRect = DefaultMultiLevelSource.getLevelImageBounds((Rectangle)sourceRect, (double)source.getModel().getScale(level));
        Assert.assertEquals((String)("at resolution level " + level + ":"), (Object)expectedRect, (Object)j2kLevelRect);
        RenderedImage levelImage = source.getImage(level);
        Rectangle levelRect = new Rectangle(0, 0, levelImage.getWidth(), levelImage.getHeight());
        Assert.assertEquals((String)("at resolution level " + level + ":"), (Object)expectedRect, (Object)levelRect);
    }

    @Test
    public void testNull() {
        MultiLevelSource mls = DefaultMultiLevelSource.NULL;
        Assert.assertEquals((long)1L, (long)mls.getModel().getLevelCount());
        Assert.assertNull((Object)mls.getModel().getModelBounds());
    }

    @Test
    public void testLevelImages() {
        PlanarImage src = DefaultMultiLevelSourceTest.createSourceImage(256, 128);
        DefaultMultiLevelSource mls = new DefaultMultiLevelSource((RenderedImage)src, 5);
        Assert.assertEquals((long)5L, (long)mls.getModel().getLevelCount());
        Assert.assertSame((Object)src, (Object)mls.getSourceImage());
        Assert.assertSame((Object)src, (Object)mls.getImage(0));
        this.testLevelImage(mls, 0, 256, 128);
        this.testLevelImage(mls, 1, 128, 64);
        this.testLevelImage(mls, 2, 64, 32);
        this.testLevelImage(mls, 3, 32, 16);
        this.testLevelImage(mls, 4, 16, 8);
    }

    private void testLevelImage(DefaultMultiLevelSource mls, int level, int ew, int eh) {
        RenderedImage image = mls.getImage(level);
        Assert.assertSame((Object)image, (Object)mls.getImage(level));
        Assert.assertEquals((long)mls.getSourceImage().getSampleModel().getDataType(), (long)image.getSampleModel().getDataType());
        Assert.assertEquals((long)mls.getSourceImage().getSampleModel().getNumBands(), (long)image.getSampleModel().getNumBands());
        Assert.assertEquals((long)ew, (long)image.getWidth());
        Assert.assertEquals((long)eh, (long)image.getHeight());
    }

    static PlanarImage createSourceImage(int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 10);
        bi.getRaster().setSample(0, 0, 0, 0);
        bi.getRaster().setSample(1, 0, 0, 1);
        bi.getRaster().setSample(0, 1, 0, 2);
        bi.getRaster().setSample(1, 1, 0, 3);
        return PlanarImage.wrapRenderedImage((RenderedImage)bi);
    }
}

