/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer;

import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.TracingLayerListener;
import com.bc.ceres.glayer.support.ShapeLayer;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.support.BufferedImageRendering;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;

public class CollectionLayerTest {
    @Test
    public void testCollection() {
        CollectionLayer collectionLayer = new CollectionLayer();
        Assert.assertTrue((boolean)collectionLayer.isCollectionLayer());
    }

    @Test
    public void testModelBounds() {
        CollectionLayer layer = new CollectionLayer();
        Assert.assertEquals(null, (Object)layer.getModelBounds());
        layer = new CollectionLayer();
        layer.getChildren().add(new CollectionLayer());
        layer.getChildren().add(new CollectionLayer());
        layer.getChildren().add(new CollectionLayer());
        Assert.assertEquals(null, (Object)layer.getModelBounds());
        layer = new CollectionLayer();
        layer.getChildren().add(new CollectionLayer());
        layer.getChildren().add(new ShapeLayer(new Shape[]{new Rectangle(20, 10, 30, 50)}, new AffineTransform()));
        layer.getChildren().add(new ShapeLayer(new Shape[]{new Rectangle(10, 20, 20, 60)}, new AffineTransform()));
        int x1 = Math.min(20, 10);
        int y1 = Math.min(10, 20);
        int x2 = Math.max(50, 30);
        int y2 = Math.max(60, 80);
        Assert.assertEquals((Object)new Rectangle(x1, y1, x2 - x1, y2 - y1), (Object)layer.getModelBounds());
        layer = new CollectionLayer();
        layer.getChildren().add(new ShapeLayer(new Shape[]{new Rectangle(-20, 10, 30, 50)}, new AffineTransform()));
        layer.getChildren().add(new ShapeLayer(new Shape[]{new Rectangle(-10, 20, 20, 60)}, new AffineTransform()));
        layer.getChildren().add(new ShapeLayer(new Shape[]{new Rectangle(1, 2, 40, 50)}, new AffineTransform()));
        x1 = Math.min(Math.min(-20, -10), 1);
        y1 = Math.min(Math.min(10, 20), 2);
        x2 = Math.max(Math.max(10, 10), 41);
        y2 = Math.max(Math.max(60, 80), 52);
        Assert.assertEquals((Object)new Rectangle(x1, y1, x2 - x1, y2 - y1), (Object)layer.getModelBounds());
    }

    @Test
    public void testRenderRecognisesVisibileState() {
        CollectionLayer layer = new CollectionLayer();
        RenderCountingLayer l1 = new RenderCountingLayer();
        RenderCountingLayer l2 = new RenderCountingLayer();
        RenderCountingLayer l3 = new RenderCountingLayer();
        layer.getChildren().add(l1);
        layer.getChildren().add(l2);
        layer.getChildren().add(l3);
        BufferedImageRendering rendering = new BufferedImageRendering(16, 16);
        layer.render((Rendering)rendering);
        Assert.assertEquals((long)1L, (long)l1.getRenderCount());
        Assert.assertEquals((long)1L, (long)l2.getRenderCount());
        Assert.assertEquals((long)1L, (long)l3.getRenderCount());
        l2.setVisible(false);
        layer.render((Rendering)rendering);
        Assert.assertEquals((long)2L, (long)l1.getRenderCount());
        Assert.assertEquals((long)1L, (long)l2.getRenderCount());
        Assert.assertEquals((long)2L, (long)l3.getRenderCount());
        l3.setVisible(false);
        layer.render((Rendering)rendering);
        Assert.assertEquals((long)3L, (long)l1.getRenderCount());
        Assert.assertEquals((long)1L, (long)l2.getRenderCount());
        Assert.assertEquals((long)2L, (long)l3.getRenderCount());
        layer.setVisible(false);
        layer.render((Rendering)rendering);
        Assert.assertEquals((long)3L, (long)l1.getRenderCount());
        Assert.assertEquals((long)1L, (long)l2.getRenderCount());
        Assert.assertEquals((long)2L, (long)l3.getRenderCount());
    }

    @Test
    public void testListInterfaceImplementionSpecConformance() {
        CollectionLayer layer = new CollectionLayer();
        List list = layer.getChildren();
        Assert.assertEquals((Object)true, (Object)list.isEmpty());
        Assert.assertEquals((long)0L, (long)list.size());
        Iterator layerIterator = list.iterator();
        Assert.assertNotNull(layerIterator);
        Assert.assertEquals((Object)false, (Object)layerIterator.hasNext());
        try {
            layerIterator.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        CollectionLayer childLayer0 = new CollectionLayer();
        list.add(childLayer0);
        Assert.assertEquals((Object)false, (Object)list.isEmpty());
        Assert.assertEquals((long)1L, (long)list.size());
        layerIterator = list.iterator();
        Assert.assertNotNull(layerIterator);
        Assert.assertEquals((Object)true, (Object)layerIterator.hasNext());
        Assert.assertSame((Object)childLayer0, layerIterator.next());
        Assert.assertEquals((Object)false, (Object)layerIterator.hasNext());
        try {
            layerIterator.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        Assert.assertSame((Object)childLayer0, list.get(0));
        try {
            list.get(1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        CollectionLayer childLayer1 = new CollectionLayer();
        list.add(childLayer1);
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertSame((Object)childLayer0, list.get(0));
        Assert.assertSame((Object)childLayer1, list.get(1));
        childLayer0 = new CollectionLayer();
        list.set(0, childLayer0);
        Assert.assertSame((Object)childLayer0, list.get(0));
        Assert.assertSame((Object)childLayer1, list.get(1));
        list.remove(childLayer0);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertSame((Object)childLayer1, list.get(0));
        list.remove(0);
        Assert.assertEquals((long)0L, (long)list.size());
        list.add(new CollectionLayer());
        list.add(new CollectionLayer());
        list.add(new CollectionLayer());
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testChildLayerListIsLife() {
        CollectionLayer owner = new CollectionLayer();
        List list = owner.getChildren();
        TracingLayerListener ll = new TracingLayerListener();
        owner.addListener((LayerListener)ll);
        list.add(new CollectionLayer());
        Assert.assertEquals((Object)"added 1;", (Object)ll.trace);
        list.add(new CollectionLayer());
        Assert.assertEquals((Object)"added 1;added 1;", (Object)ll.trace);
        Assert.assertSame((Object)owner, (Object)((Layer)list.get(0)).getParent());
        Assert.assertSame((Object)owner, (Object)((Layer)list.get(1)).getParent());
        Layer layer0 = (Layer)list.remove(0);
        Assert.assertNull((Object)layer0.getParent());
        Assert.assertEquals((Object)"added 1;added 1;removed 1;", (Object)ll.trace);
        layer0 = (Layer)list.set(0, new CollectionLayer());
        Assert.assertNull((Object)layer0.getParent());
        Assert.assertEquals((Object)"added 1;added 1;removed 1;removed 1;added 1;", (Object)ll.trace);
    }

    private static class RenderCountingLayer
    extends CollectionLayer {
        private int renderCount;

        private RenderCountingLayer() {
        }

        protected void renderLayer(Rendering rendering) {
            ++this.renderCount;
        }

        public int getRenderCount() {
            return this.renderCount;
        }
    }
}

