/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glevel.support;

import com.bc.ceres.glevel.MultiLevelModel;
import com.bc.ceres.glevel.MultiLevelSource;
import com.bc.ceres.glevel.support.AbstractMultiLevelSource;
import com.bc.ceres.glevel.support.DefaultMultiLevelImage;
import com.bc.ceres.glevel.support.DefaultMultiLevelModel;
import com.bc.ceres.glevel.support.DefaultMultiLevelSource;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.media.jai.PlanarImage;
import junit.framework.TestCase;

public class DefaultMultiLevelImageTest
extends TestCase {
    public void testSamplesAreProvidedFromSource() {
        PlanarImage sourceImage = DefaultMultiLevelImageTest.createSingleBandedByteImage(2, 2);
        DefaultMultiLevelSource mls = new DefaultMultiLevelSource((RenderedImage)sourceImage, 1);
        DefaultMultiLevelImage mli = new DefaultMultiLevelImage((MultiLevelSource)mls);
        DefaultMultiLevelImageTest.assertSame((Object)mls, (Object)mli.getSource());
        DefaultMultiLevelImageTest.assertSame((Object)sourceImage, (Object)mli.getImage(0));
        DefaultMultiLevelImageTest.assertSame((Object)mls.getImage(0), (Object)mli.getImage(0));
        DefaultMultiLevelImageTest.assertEquals((int)11, (int)mli.getData().getSample(0, 0, 0));
        DefaultMultiLevelImageTest.assertEquals((int)22, (int)mli.getData().getSample(1, 0, 0));
        DefaultMultiLevelImageTest.assertEquals((int)33, (int)mli.getData().getSample(0, 1, 0));
        DefaultMultiLevelImageTest.assertEquals((int)44, (int)mli.getData().getSample(1, 1, 0));
    }

    public void testLevelInstances() {
        DefaultMultiLevelImage mli = this.createSomeDefaultMultiLevelImage();
        RenderedImage a0 = mli.getImage(0);
        DefaultMultiLevelImageTest.assertNotNull((Object)a0);
        DefaultMultiLevelImageTest.assertSame((Object)a0, (Object)mli.getImage(0));
        RenderedImage a1 = mli.getImage(1);
        DefaultMultiLevelImageTest.assertNotNull((Object)a1);
        DefaultMultiLevelImageTest.assertSame((Object)a1, (Object)mli.getImage(1));
        mli.reset();
        RenderedImage b0 = mli.getImage(0);
        DefaultMultiLevelImageTest.assertNotNull((Object)b0);
        DefaultMultiLevelImageTest.assertSame((Object)b0, (Object)mli.getImage(0));
        DefaultMultiLevelImageTest.assertNotSame((Object)a0, (Object)b0);
        RenderedImage b1 = mli.getImage(1);
        DefaultMultiLevelImageTest.assertNotNull((Object)b1);
        DefaultMultiLevelImageTest.assertSame((Object)b1, (Object)mli.getImage(1));
        DefaultMultiLevelImageTest.assertNotSame((Object)a1, (Object)b1);
    }

    public void testProperties() {
        DefaultMultiLevelImage mli = this.createSomeDefaultMultiLevelImage();
        PCL pcl = new PCL();
        DefaultMultiLevelImageTest.assertEquals((Object)Image.UndefinedProperty, (Object)mli.getProperty("_x"));
        mli.addPropertyChangeListener((PropertyChangeListener)pcl);
        mli.setProperty("_x", (Object)4384);
        DefaultMultiLevelImageTest.assertEquals((Object)4384, (Object)mli.getProperty("_x"));
        DefaultMultiLevelImageTest.assertEquals(Integer.class, (Object)mli.getPropertyClass("_x"));
        DefaultMultiLevelImageTest.assertEquals((String)"_x;", (String)pcl.trace);
        String[] propertyNames = mli.getPropertyNames();
        DefaultMultiLevelImageTest.assertEquals((int)1, (int)propertyNames.length);
        DefaultMultiLevelImageTest.assertEquals((String)"_x", (String)propertyNames[0]);
        propertyNames = mli.getPropertyNames("_");
        DefaultMultiLevelImageTest.assertEquals((int)1, (int)propertyNames.length);
        DefaultMultiLevelImageTest.assertEquals((String)"_x", (String)propertyNames[0]);
        mli.removeProperty("_x");
        DefaultMultiLevelImageTest.assertEquals((Object)Image.UndefinedProperty, (Object)mli.getProperty("_x"));
    }

    private DefaultMultiLevelImage createSomeDefaultMultiLevelImage() {
        DefaultMultiLevelModel model = new DefaultMultiLevelModel(2, new AffineTransform(), 256, 256);
        TestMultiLevelSource mls = new TestMultiLevelSource(model);
        return new DefaultMultiLevelImage((MultiLevelSource)mls);
    }

    static PlanarImage createSingleBandedByteImage(int w, int h) {
        BufferedImage bi = new BufferedImage(w, h, 10);
        bi.getRaster().setSample(0, 0, 0, 11);
        bi.getRaster().setSample(1, 0, 0, 22);
        bi.getRaster().setSample(0, 1, 0, 33);
        bi.getRaster().setSample(1, 1, 0, 44);
        return PlanarImage.wrapRenderedImage((RenderedImage)bi);
    }

    private static class PCL
    implements PropertyChangeListener {
        String trace = "";

        private PCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.trace = this.trace + evt.getPropertyName() + ";";
        }
    }

    private static class TestMultiLevelSource
    extends AbstractMultiLevelSource {
        public TestMultiLevelSource(DefaultMultiLevelModel model) {
            super((MultiLevelModel)model);
        }

        protected RenderedImage createImage(int level) {
            int width = (int)Math.floor(256.0 / this.getModel().getScale(level));
            int height = (int)Math.floor(256.0 / this.getModel().getScale(level));
            return DefaultMultiLevelImageTest.createSingleBandedByteImage(width, height);
        }
    }
}

