/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.support;

import com.bc.ceres.glayer.Assert2D;
import com.bc.ceres.glayer.support.ShapeLayer;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ShapeLayerTest {
    @Test
    public void testConstructors() {
        Rectangle2D.Double shape = new Rectangle2D.Double(0.0, 0.0, 320.0, 200.0);
        ShapeLayer layer = new ShapeLayer(new Shape[]{shape}, new AffineTransform());
        List shapeList = layer.getShapeList();
        Assert.assertNotNull((Object)shapeList);
        Assert.assertNotSame((Object)shapeList, (Object)layer.getShapeList());
        Assert.assertEquals((long)1L, (long)shapeList.size());
        Assert.assertSame((Object)shape, shapeList.get(0));
        AffineTransform s2u = AffineTransform.getTranslateInstance(100.0, 200.0);
        layer = new ShapeLayer(new Shape[]{shape}, s2u);
        Assert.assertEquals((Object)AffineTransform.getTranslateInstance(100.0, 200.0), (Object)layer.getShapeToModelTransform());
        Assert.assertEquals((Object)AffineTransform.getTranslateInstance(-100.0, -200.0), (Object)layer.getModelToShapeTransform());
    }

    @Test
    public void testModelBounds() {
        ShapeLayer layer = new ShapeLayer(new Shape[0], new AffineTransform());
        Assert2D.assertEquals(null, layer.getModelBounds());
        Rectangle shape = new Rectangle(10, -30, 320, 200);
        layer = new ShapeLayer(new Shape[]{shape}, new AffineTransform());
        Assert.assertNotNull((Object)layer.getModelBounds());
        Assert2D.assertEquals(new Rectangle(10, -30, 320, 200), layer.getModelBounds());
        AffineTransform s2m = new AffineTransform(0.5, 0.0, 0.0, 0.5, -25.5, 50.3);
        layer = new ShapeLayer(new Shape[]{shape}, s2m);
        Assert.assertNotNull((Object)layer.getModelBounds());
        Assert2D.assertEquals(new Rectangle2D.Double(-20.5, 35.3, 160.0, 100.0), layer.getModelBounds());
    }
}

