/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.support;

import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.glayer.support.filters.NameFilter;
import junit.framework.TestCase;

public class LayerUtilsTest
extends TestCase {
    static Layer createLayerTree() {
        CollectionLayer root = new CollectionLayer("R");
        root.getChildren().add(new CollectionLayer("A"));
        root.getChildren().add(new CollectionLayer("B"));
        root.getChildren().add(new CollectionLayer("C"));
        root.getChildren().add(new CollectionLayer("D"));
        Layer layerC = LayerUtils.getChildLayerByName((Layer)root, (String)"C");
        LayerUtilsTest.assertNotNull((Object)layerC);
        layerC.getChildren().add(new CollectionLayer("C1"));
        layerC.getChildren().add(new CollectionLayer("C2"));
        layerC.getChildren().add(new CollectionLayer("C3"));
        return root;
    }

    public void testGetChildLayerIndex() {
        Layer root = LayerUtilsTest.createLayerTree();
        LayerUtilsTest.assertEquals((int)0, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-1, (LayerFilter)new NameFilter("A")));
        LayerUtilsTest.assertEquals((int)1, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-1, (LayerFilter)new NameFilter("B")));
        LayerUtilsTest.assertEquals((int)2, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-1, (LayerFilter)new NameFilter("C")));
        LayerUtilsTest.assertEquals((int)2, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-1, (LayerFilter)new NameFilter("C1")));
        LayerUtilsTest.assertEquals((int)2, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-1, (LayerFilter)new NameFilter("C2")));
        LayerUtilsTest.assertEquals((int)2, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-1, (LayerFilter)new NameFilter("C3")));
        LayerUtilsTest.assertEquals((int)-1, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-1, (LayerFilter)new NameFilter("C4")));
        LayerUtilsTest.assertEquals((int)3, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-1, (LayerFilter)new NameFilter("D")));
        LayerUtilsTest.assertEquals((int)-1, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-1, (LayerFilter)new NameFilter("E")));
        LayerUtilsTest.assertEquals((int)0, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.FLAT, (int)-1, (LayerFilter)new NameFilter("A")));
        LayerUtilsTest.assertEquals((int)1, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.FLAT, (int)-1, (LayerFilter)new NameFilter("B")));
        LayerUtilsTest.assertEquals((int)2, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.FLAT, (int)-1, (LayerFilter)new NameFilter("C")));
        LayerUtilsTest.assertEquals((int)-1, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.FLAT, (int)-1, (LayerFilter)new NameFilter("C1")));
        LayerUtilsTest.assertEquals((int)-1, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.FLAT, (int)-1, (LayerFilter)new NameFilter("C2")));
        LayerUtilsTest.assertEquals((int)-1, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.FLAT, (int)-1, (LayerFilter)new NameFilter("C3")));
        LayerUtilsTest.assertEquals((int)-1, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.FLAT, (int)-1, (LayerFilter)new NameFilter("C4")));
        LayerUtilsTest.assertEquals((int)3, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.FLAT, (int)-1, (LayerFilter)new NameFilter("D")));
        LayerUtilsTest.assertEquals((int)-1, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.FLAT, (int)-1, (LayerFilter)new NameFilter("E")));
        LayerUtilsTest.assertEquals((int)-999, (int)LayerUtils.getChildLayerIndex((Layer)root, (LayerUtils.SearchMode)LayerUtils.SearchMode.DEEP, (int)-999, (LayerFilter)new NameFilter("E")));
    }

    public void testGetLayerPath() {
        Layer root = LayerUtilsTest.createLayerTree();
        Layer layerA = LayerUtils.getChildLayerByName((Layer)root, (String)"A");
        Layer layerC = LayerUtils.getChildLayerByName((Layer)root, (String)"C");
        Layer layerC2 = LayerUtils.getChildLayerByName((Layer)root, (String)"C2");
        Layer[] pathA = LayerUtils.getLayerPath((Layer)root, (Layer)layerA);
        LayerUtilsTest.assertNotNull((Object)pathA);
        LayerUtilsTest.assertEquals((int)2, (int)pathA.length);
        LayerUtilsTest.assertSame((Object)root, (Object)pathA[0]);
        LayerUtilsTest.assertSame((Object)layerA, (Object)pathA[1]);
        Layer[] pathC2 = LayerUtils.getLayerPath((Layer)root, (Layer)layerC2);
        LayerUtilsTest.assertNotNull((Object)pathC2);
        LayerUtilsTest.assertEquals((int)3, (int)pathC2.length);
        LayerUtilsTest.assertSame((Object)root, (Object)pathC2[0]);
        LayerUtilsTest.assertSame((Object)layerC, (Object)pathC2[1]);
        LayerUtilsTest.assertSame((Object)layerC2, (Object)pathC2[2]);
    }

    public void testGetRootLayer() {
        Layer root = LayerUtilsTest.createLayerTree();
        Layer directRoot = LayerUtils.getRootLayer((Layer)root);
        LayerUtilsTest.assertSame((Object)root, (Object)directRoot);
        Layer layerC = LayerUtils.getChildLayerByName((Layer)root, (String)"C");
        Layer cRoot = LayerUtils.getRootLayer((Layer)layerC);
        LayerUtilsTest.assertSame((Object)root, (Object)cRoot);
        Layer layerC2 = LayerUtils.getChildLayerByName((Layer)root, (String)"C2");
        Layer c2Root = LayerUtils.getRootLayer((Layer)layerC2);
        LayerUtilsTest.assertSame((Object)root, (Object)c2Root);
    }
}

