/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.jaitests;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.HashSet;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.operator.FormatDescriptor;
import junit.framework.TestCase;

public class PlanarImageTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testThatTileSchedulerFiresEventsForAlreadyAvailableTiles() {
        RenderedOp tiledImage = PlanarImageTest.createTiledAndCachedImage();
        Point[] indices = tiledImage.getTileIndices(new Rectangle(1, 1, 511, 511));
        PlanarImageTest.assertNotNull((Object)indices);
        PlanarImageTest.assertEquals((int)16, (int)indices.length);
        Raster[] expectedTiles = tiledImage.getTiles();
        Raster[] listener = new MyTileComputationListener(16);
        tiledImage.addTileComputationListener((TileComputationListener)listener);
        tiledImage.queueTiles(indices);
        try {
            Raster[] rasterArray = listener;
            synchronized (listener) {
                listener.wait(1000L);
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (InterruptedException e) {
            PlanarImageTest.fail();
        }
        {
            PlanarImageTest.assertEquals((int)((MyTileComputationListener)listener).expectedSize, (int)((MyTileComputationListener)listener).computedTiles.size());
            for (Raster expectedTile : expectedTiles) {
                PlanarImageTest.assertTrue((boolean)((MyTileComputationListener)listener).computedTiles.contains(expectedTile));
            }
            return;
        }
    }

    private static RenderedOp createTiledAndCachedImage() {
        BufferedImage image = new BufferedImage(512, 512, 2);
        ImageLayout imageLayout = new ImageLayout();
        imageLayout.setTileWidth(128);
        imageLayout.setTileHeight(128);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, JAI.getDefaultInstance().getTileCache()));
        return FormatDescriptor.create((RenderedImage)image, (Integer)image.getSampleModel().getDataType(), (RenderingHints)hints);
    }

    private static class MyTileComputationListener
    implements TileComputationListener {
        private final int expectedSize;
        private HashSet<Raster> computedTiles;

        private MyTileComputationListener(int expectedSize) {
            this.expectedSize = expectedSize;
            this.computedTiles = new HashSet(expectedSize * 2);
        }

        public synchronized void tileComputed(Object o, TileRequest[] tileRequests, PlanarImage planarImage, int tileX, int tileY, Raster raster) {
            this.computedTiles.add(raster);
            if (this.computedTiles.size() == this.expectedSize) {
                this.notify();
            }
        }

        public void tileCancelled(Object o, TileRequest[] tileRequests, PlanarImage planarImage, int tileX, int tileY) {
        }

        public void tileComputationFailure(Object o, TileRequest[] tileRequests, PlanarImage planarImage, int tileX, int tileY, Throwable throwable) {
        }
    }
}

