/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.jaitests;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.util.Range;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class OperationDescriptorEditor {
    private final OperationDescriptor operationDescriptor;
    private final ArrayList<ParameterDescriptor> parameterDescriptors;
    private final String modeName;
    static final HashMap<Interpolation, String> I2S = new HashMap(8);
    static final Interpolation[] INTERPOLATION_VALUES = new Interpolation[]{Interpolation.getInstance((int)0), Interpolation.getInstance((int)1), Interpolation.getInstance((int)2), Interpolation.getInstance((int)3)};
    static final String[] INTERPOLATION_NAMES = new String[]{"INTERP_NEAREST", "INTERP_BILINEAR", "INTERP_BICUBIC", "INTERP_BICUBIC_2"};

    public OperationDescriptorEditor(OperationDescriptor operationDescriptor) {
        this(operationDescriptor, "rendered");
    }

    public OperationDescriptorEditor(OperationDescriptor operationDescriptor, String modeName) {
        this.operationDescriptor = operationDescriptor;
        this.modeName = modeName;
        ParameterListDescriptor descriptor = operationDescriptor.getParameterListDescriptor(modeName);
        String[] names = descriptor.getParamNames();
        Class[] classes = descriptor.getParamClasses();
        Object[] defaultValues = descriptor.getParamDefaults();
        this.parameterDescriptors = new ArrayList(names.length);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Class type = classes[i];
            Object defaultValue = defaultValues[i];
            Range range = descriptor.getParamValueRange(name);
            EnumeratedParameter[] enumeratedParameters = EnumeratedParameter.class.isAssignableFrom(type) ? descriptor.getEnumeratedParameterValues(name) : null;
            ParameterDescriptor parameterDescriptor = new ParameterDescriptor(name, type, defaultValue, range, enumeratedParameters);
            this.parameterDescriptors.add(parameterDescriptor);
        }
    }

    public OperationDescriptor getOperationDescriptor() {
        return this.operationDescriptor;
    }

    public String getModeName() {
        return this.modeName;
    }

    public JPanel createPanel() {
        GridBagLayout bagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 256;
        constraints.fill = 2;
        constraints.insets = new Insets(1, 0, 1, 2);
        JPanel panel = new JPanel(bagLayout);
        constraints.gridx = 0;
        constraints.weightx = 0.5;
        constraints.weighty = 0.0;
        constraints.gridy = 0;
        for (ParameterDescriptor parameterDescriptor : this.parameterDescriptors) {
            JLabel label = new JLabel(parameterDescriptor.name + " (" + parameterDescriptor.type.getSimpleName() + "): ");
            JComponent editor = this.getEditor(parameterDescriptor);
            constraints.gridx = 0;
            constraints.weightx = 0.5;
            constraints.weighty = 0.0;
            panel.add((Component)label, constraints);
            constraints.gridx = 1;
            constraints.weightx = 0.5;
            constraints.weighty = 0.0;
            panel.add((Component)editor, constraints);
            ++constraints.gridy;
        }
        constraints.gridx = 0;
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        panel.add((Component)new JPanel(), constraints);
        return panel;
    }

    private JComponent getEditor(ParameterDescriptor parameterDescriptor) {
        if (parameterDescriptor.type.equals(Boolean.class)) {
            return new JComboBox<Object>(new Object[]{Boolean.TRUE, Boolean.FALSE});
        }
        if (EnumeratedParameter.class.isAssignableFrom(parameterDescriptor.type) && parameterDescriptor.enumeratedParameters != null) {
            JComboBox<EnumeratedParameter> comboBox = new JComboBox<EnumeratedParameter>(parameterDescriptor.enumeratedParameters);
            comboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    label.setText(((EnumeratedParameter)value).getName());
                    return label;
                }
            });
            return comboBox;
        }
        if (Interpolation.class.isAssignableFrom(parameterDescriptor.type)) {
            JComboBox<Interpolation> comboBox = new JComboBox<Interpolation>(INTERPOLATION_VALUES);
            comboBox.setRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    Interpolation interpolation = (Interpolation)value;
                    label.setText(I2S.get(interpolation));
                    return label;
                }
            });
            return comboBox;
        }
        if (Number.class.isAssignableFrom(parameterDescriptor.type)) {
            return new JTextField(6);
        }
        return new JTextField(20);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            args = new String[]{"FileLoad", "MedianFilter", "Transpose", "Mosaic", "Scale", "Format", "Rescale"};
        }
        JTabbedPane jTabbedPane = new JTabbedPane();
        for (String opName : args) {
            OperationDescriptor descriptor = (OperationDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor("rendered", opName);
            OperationDescriptorEditor descriptorEditor = new OperationDescriptorEditor(descriptor);
            JPanel panel = descriptorEditor.createPanel();
            jTabbedPane.add(opName, new JScrollPane(panel));
        }
        JFrame frame = new JFrame("OperationDescriptorEditor-Test");
        frame.add((Component)jTabbedPane, "Center");
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    static {
        for (int i = 0; i < INTERPOLATION_VALUES.length; ++i) {
            Interpolation interpolation = INTERPOLATION_VALUES[i];
            I2S.put(interpolation, INTERPOLATION_NAMES[i]);
        }
    }

    private final class ParameterDescriptor {
        final String name;
        final Class type;
        final Object defaultValue;
        final Range range;
        final EnumeratedParameter[] enumeratedParameters;

        ParameterDescriptor(String name, Class type, Object defaultValue, Range range, EnumeratedParameter[] enumeratedParameters) {
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
            this.range = range;
            this.enumeratedParameters = enumeratedParameters;
        }
    }
}

