/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.jaitests;

import com.sun.media.jai.codec.FileCacheSeekableStream;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.media.jai.ImageMIPMap;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.operator.BandSelectDescriptor;
import javax.media.jai.operator.StreamDescriptor;
import javax.media.jai.util.ImagingListener;
import junit.framework.TestCase;

public class ImageMIPMapTest
extends TestCase {
    public ImageMIPMapTest() {
        JAI.getDefaultInstance().setImagingListener(new ImagingListener(){

            public boolean errorOccurred(String message, Throwable thrown, Object where, boolean isRetryable) throws RuntimeException {
                System.out.println("JAI error occurred: " + message);
                return false;
            }
        });
        long memoryCapacity = 0x10000000L;
        JAI.getDefaultInstance().getTileCache().setMemoryCapacity(0x10000000L);
        JAI.getDefaultInstance().getTileCache().setMemoryThreshold(0.75f);
    }

    public void testImageMIPMap() throws IOException {
        PlanarImage image = ImageMIPMapTest.loadImage();
        ImageMIPMapTest.assertEquals((int)4, (int)image.getSampleModel().getNumBands());
        ImageMIPMapTest.testRes((RenderedImage)image, 1000, 1104, 256, 256);
        image = ImageMIPMapTest.selectBand(image);
        ImageMIPMapTest.assertEquals((int)1, (int)image.getSampleModel().getNumBands());
        ImageMIPMapTest.testRes((RenderedImage)image, 1000, 1104, 256, 256);
        ImageMIPMap mipMap = new ImageMIPMap((RenderedImage)image, AffineTransform.getScaleInstance(0.5, 0.5), Interpolation.getInstance((int)0));
        ImageMIPMapTest.testRes(mipMap.getImage(0), 1000, 1104, 256, 256);
        ImageMIPMapTest.testRes(mipMap.getImage(1), 500, 552, 256, 256);
        ImageMIPMapTest.testRes(mipMap.getImage(2), 250, 276, 250, 256);
        ImageMIPMapTest.testRes(mipMap.getImage(3), 125, 138, 125, 138);
        ImageMIPMapTest.testRes(mipMap.getImage(4), 62, 69, 62, 69);
        ImageMIPMapTest.testRes(mipMap.getImage(5), 31, 34, 31, 34);
        ImageMIPMapTest.testRes(mipMap.getImage(6), 15, 17, 15, 17);
        ImageMIPMapTest.testRes(mipMap.getImage(7), 7, 8, 7, 8);
        ImageMIPMapTest.testRes(mipMap.getImage(8), 3, 4, 3, 4);
        ImageMIPMapTest.testRes(mipMap.getImage(9), 1, 2, 1, 2);
        try {
            ImageMIPMapTest.testRes(mipMap.getImage(10), 1, 1, 1, 1);
            ImageMIPMapTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void testRes(RenderedImage image, int w, int h, int tw, int th) {
        ImageMIPMapTest.assertEquals((int)w, (int)image.getWidth());
        ImageMIPMapTest.assertEquals((int)h, (int)image.getHeight());
        ImageMIPMapTest.assertEquals((int)tw, (int)image.getTileWidth());
        ImageMIPMapTest.assertEquals((int)th, (int)image.getTileHeight());
    }

    private static PlanarImage loadImage() throws IOException {
        InputStream stream = ImageMIPMapTest.class.getResourceAsStream("/images/mapimage.png");
        RenderedOp image = StreamDescriptor.create((SeekableStream)new FileCacheSeekableStream(stream), null, null);
        return new TiledImage((RenderedImage)image, 256, 256);
    }

    private static PlanarImage selectBand(PlanarImage source) throws IOException {
        return BandSelectDescriptor.create((RenderedImage)source, (int[])new int[]{0}, null);
    }
}

