/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.jaitests;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.junit.Ignore;

@Ignore
public class ImageDrawingPerformanceTest {
    private static final String[] BUFFERED_IMAGE_TYPE_NAMES = new String[]{"TYPE_3BYTE_BGR", "TYPE_4BYTE_ABGR", "TYPE_4BYTE_ABGR_PRE", "TYPE_BYTE_BINARY", "TYPE_BYTE_GRAY", "TYPE_BYTE_INDEXED", "TYPE_INT_ARGB", "TYPE_INT_ARGB_PRE", "TYPE_INT_BGR", "TYPE_INT_RGB", "TYPE_USHORT_555_RGB", "TYPE_USHORT_565_RGB", "TYPE_USHORT_GRAY"};

    public static void main(String[] args) throws IOException {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        JFrame frame = new JFrame("ImageDrawingPerformanceTest");
        frame.getContentPane().add(new TestCanvas());
        frame.setDefaultCloseOperation(3);
        frame.setSize(screenSize);
        frame.setVisible(true);
    }

    private static class TestCanvas
    extends JComponent {
        private BufferedImage image = ImageIO.read(new File("src/test/resources/images/image-with-alpha.png"));

        private TestCanvas() throws IOException {
        }

        @Override
        protected void paintComponent(Graphics g) {
            System.out.printf("==> paintComponent: clip=%s\n", g.getClip());
            System.out.println("name\ttype\ttime(ms)\tFPS");
            Graphics2D graphics2D = (Graphics2D)g;
            for (String typeName : BUFFERED_IMAGE_TYPE_NAMES) {
                this.test(graphics2D, new BufferedImage(this.getWidth(), this.getHeight(), TestCanvas.getType(typeName)), typeName);
            }
            this.test(graphics2D, graphics2D.getDeviceConfiguration().createCompatibleImage(this.getWidth(), this.getHeight(), this.image.getTransparency()), "COMPATIBLE");
        }

        private void test(Graphics2D graphics2D, BufferedImage bufferedImage, String typeName) {
            int type = bufferedImage.getType();
            Graphics2D imageG = bufferedImage.createGraphics();
            imageG.drawImage(this.image, null, 0, 0);
            imageG.setFont(this.getFont().deriveFont(32.0f));
            imageG.drawString(String.format("type = %d (%s)", type, typeName), 100, 100);
            imageG.dispose();
            graphics2D.drawRenderedImage(bufferedImage, null);
            long t0 = System.nanoTime();
            int n = 10;
            for (int j = 0; j < 10; ++j) {
                graphics2D.drawRenderedImage(bufferedImage, null);
            }
            double time = (double)(System.nanoTime() - t0) / 1048576.0 / 10.0;
            double fps = 1000.0 / time;
            System.out.println(typeName + "\t" + type + "\t" + time + "\t" + fps);
        }

        private static int getType(String typeName) {
            int type = 0;
            try {
                type = BufferedImage.class.getField(typeName).getInt(null);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return type;
        }
    }
}

