/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.annotations;

import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerContext;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.annotations.LayerTypeMetadata;
import org.junit.Assert;
import org.junit.Test;

public class LayerTypeMetadataTest {
    @Test
    public void testAnnotatedLayerType() {
        AnnotatedLayerType layerType = new AnnotatedLayerType();
        Assert.assertEquals((Object)"ALT", (Object)layerType.getName());
        Assert.assertArrayEquals((Object[])new String[]{"x", "y", "z"}, (Object[])layerType.getAliases());
    }

    @Test
    public void testNonAnnotatedLayerType() {
        NonAnnotatedLayerType layerType = new NonAnnotatedLayerType();
        Assert.assertEquals((Object)((Object)((Object)layerType)).getClass().getName(), (Object)layerType.getName());
        Assert.assertArrayEquals((Object[])new String[0], (Object[])layerType.getAliases());
    }

    @Test
    public void testDerivedAnnotatedLayerType() {
        DerivedAnnotatedLayerType layerType = new DerivedAnnotatedLayerType();
        Assert.assertEquals((Object)((Object)((Object)layerType)).getClass().getName(), (Object)layerType.getName());
        Assert.assertArrayEquals((Object[])new String[]{"u", "v"}, (Object[])layerType.getAliases());
    }

    @Test
    public void testDerivedNonAnnotatedLayerType() {
        DerivedNonAnnotatedLayerType layerType = new DerivedNonAnnotatedLayerType();
        Assert.assertEquals((Object)((Object)((Object)layerType)).getClass().getName(), (Object)layerType.getName());
        Assert.assertArrayEquals((Object[])new String[0], (Object[])layerType.getAliases());
    }

    public static class NonAnnotatedLayerType
    extends LayerType {
        public boolean isValidFor(LayerContext ctx) {
            return false;
        }

        public Layer createLayer(LayerContext ctx, PropertySet layerConfig) {
            return null;
        }

        public PropertySet createLayerConfig(LayerContext ctx) {
            return null;
        }
    }

    @LayerTypeMetadata(name="ALT", aliasNames={"x", "y", "z"})
    public static class AnnotatedLayerType
    extends LayerType {
        public boolean isValidFor(LayerContext ctx) {
            return false;
        }

        public Layer createLayer(LayerContext ctx, PropertySet layerConfig) {
            return null;
        }

        public PropertySet createLayerConfig(LayerContext ctx) {
            return null;
        }
    }

    public static class DerivedNonAnnotatedLayerType
    extends AnnotatedLayerType {
    }

    @LayerTypeMetadata(aliasNames={"u", "v"})
    public static class DerivedAnnotatedLayerType
    extends AnnotatedLayerType {
    }
}

