/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer;

import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.support.ImageLayer;
import java.util.Set;
import junit.framework.TestCase;

public class LayerTypeRegistryTest
extends TestCase {
    public void testGetLayerTypeByClass() {
        LayerTypeRegistryTest.assertNotNull((Object)LayerTypeRegistry.getLayerType(CollectionLayer.Type.class));
        LayerTypeRegistryTest.assertNotNull((Object)LayerTypeRegistry.getLayerType(ImageLayer.Type.class));
    }

    public void testGetLayerTypeByName() {
        LayerTypeRegistryTest.assertNotNull((Object)LayerTypeRegistry.getLayerType((String)CollectionLayer.Type.class.getName()));
        LayerTypeRegistryTest.assertNotNull((Object)LayerTypeRegistry.getLayerType((String)ImageLayer.Type.class.getName()));
    }

    public void testLayerTypeIsOfCorrectType() {
        LayerType collectionLayerType = LayerTypeRegistry.getLayerType((String)CollectionLayer.Type.class.getName());
        LayerTypeRegistryTest.assertTrue((boolean)(collectionLayerType instanceof CollectionLayer.Type));
        LayerType imageLayerType = LayerTypeRegistry.getLayerType((String)ImageLayer.Type.class.getName());
        LayerTypeRegistryTest.assertTrue((boolean)(imageLayerType instanceof ImageLayer.Type));
    }

    public void testAliases() {
        LayerType imageLayerType = LayerTypeRegistry.getLayerType((String)"ImageLayerType");
        LayerTypeRegistryTest.assertTrue((boolean)(imageLayerType instanceof ImageLayer.Type));
    }

    public void testGetLayerTypes() {
        Set layerTypeSet1 = LayerTypeRegistry.getLayerTypes();
        LayerTypeRegistryTest.assertNotNull((Object)layerTypeSet1);
        LayerTypeRegistryTest.assertTrue((layerTypeSet1.size() > 0 ? 1 : 0) != 0);
        Set layerTypeSet2 = LayerTypeRegistry.getLayerTypes();
        LayerTypeRegistryTest.assertNotSame((Object)layerTypeSet1, (Object)layerTypeSet2);
    }
}

