/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.glayer.CollectionLayer;
import com.bc.ceres.glayer.Composite;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.LayerType;
import com.bc.ceres.glayer.LayerTypeRegistry;
import com.bc.ceres.glayer.TracingLayerListener;
import org.junit.Assert;
import org.junit.Test;

public class LayerTest {
    @Test
    public void testType() {
        CollectionLayer layer1 = new CollectionLayer();
        CollectionLayer layer2 = new CollectionLayer();
        Assert.assertNotNull((Object)layer1.getLayerType());
        Assert.assertSame((Object)layer1.getLayerType(), (Object)layer2.getLayerType());
        Assert.assertSame((Object)layer1.getLayerType(), (Object)LayerTypeRegistry.getLayerType(CollectionLayer.Type.class));
    }

    @Test
    public void testDefaults() throws ValidationException {
        CollectionLayer layer = new CollectionLayer();
        LayerType layerType = layer.getLayerType();
        Assert.assertNotNull((Object)layerType);
        Assert.assertTrue((layerType.createLayer(null, (PropertySet)new PropertyContainer()) != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)layerType.isValidFor(null));
        Assert.assertNotNull((Object)layer.getId());
        Assert.assertEquals((Object)"Collection Layer", (Object)layer.getName());
        Assert.assertEquals((Object)true, (Object)layer.isVisible());
        Assert.assertEquals((double)0.0, (double)layer.getTransparency(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)layer.getSwipePercent(), (double)1.0E-10);
        Assert.assertEquals((Object)Composite.SRC_OVER, (Object)layer.getComposite());
        Assert.assertNull((Object)layer.getModelBounds());
    }

    @Test
    public void testPropertyAccess() {
        CollectionLayer layer = new CollectionLayer();
        Assert.assertEquals((Object)true, (Object)layer.isVisible());
        layer.setVisible(false);
        Assert.assertEquals((Object)false, (Object)layer.isVisible());
        layer.setVisible(true);
        Assert.assertEquals((Object)true, (Object)layer.isVisible());
        Assert.assertEquals((Object)"Collection Layer", (Object)layer.getName());
        layer.setName("Grid");
        Assert.assertEquals((Object)"Grid", (Object)layer.getName());
        layer.setName("Earth grid");
        Assert.assertEquals((Object)"Earth grid", (Object)layer.getName());
        try {
            layer.setName(null);
            Assert.fail((String)"NullPointerException expected");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertEquals((double)0.0, (double)layer.getTransparency(), (double)1.0E-10);
        layer.setTransparency(0.1);
        Assert.assertEquals((double)0.1, (double)layer.getTransparency(), (double)1.0E-10);
        layer.setTransparency(1.0);
        Assert.assertEquals((double)1.0, (double)layer.getTransparency(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)layer.getSwipePercent(), (double)1.0E-10);
        layer.setSwipePercent(0.1);
        Assert.assertEquals((double)0.1, (double)layer.getSwipePercent(), (double)1.0E-10);
        layer.setSwipePercent(1.0);
        Assert.assertEquals((double)1.0, (double)layer.getSwipePercent(), (double)1.0E-10);
        Assert.assertEquals((Object)Composite.SRC_OVER, (Object)layer.getComposite());
        layer.setComposite(Composite.DST_OUT);
        Assert.assertEquals((Object)Composite.DST_OUT, (Object)layer.getComposite());
    }

    @Test
    public void testPropertyChangeNotification() {
        CollectionLayer layer = new CollectionLayer();
        TracingLayerListener ll = new TracingLayerListener();
        layer.addListener((LayerListener)ll);
        layer.setName("Grid");
        layer.setVisible(false);
        layer.setTransparency(0.5);
        Assert.assertEquals((Object)"name;visible;transparency;", (Object)ll.trace);
        layer.setName("Grid");
        layer.setVisible(false);
        layer.setTransparency(0.0);
        Assert.assertEquals((Object)"name;visible;transparency;transparency;", (Object)ll.trace);
        layer.setTransparency(0.0);
        layer.setVisible(true);
        layer.setName("Raster");
        Assert.assertEquals((Object)"name;visible;transparency;transparency;visible;name;", (Object)ll.trace);
        layer.setComposite(Composite.DST_IN);
        Assert.assertEquals((Object)"name;visible;transparency;transparency;visible;name;composite;", (Object)ll.trace);
        ll.trace = "";
        layer.removeListener((LayerListener)ll);
        layer.setTransparency(0.25);
        layer.setVisible(false);
        layer.setName("Graticule");
        layer.setComposite(Composite.SRC_OUT);
        Assert.assertEquals((Object)"", (Object)ll.trace);
    }
}

