/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.CollectionData;
import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.TracingIOHandler;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import com.bc.ceres.binio.VarSequenceType;
import com.bc.ceres.binio.internal.CompoundInstance;
import com.bc.ceres.binio.internal.FixCompound;
import com.bc.ceres.binio.internal.FixSequenceOfFixCollections;
import com.bc.ceres.binio.internal.FixSequenceOfSimples;
import com.bc.ceres.binio.internal.FixSequenceOfVarCollections;
import com.bc.ceres.binio.internal.InstanceFactory;
import com.bc.ceres.binio.internal.VarCompound;
import com.bc.ceres.binio.internal.VarElementCountSequenceType;
import com.bc.ceres.binio.smos.SmosProduct;
import com.bc.ceres.binio.util.ByteArrayIOHandler;
import com.bc.ceres.binio.util.ImageIOHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;

public class InstanceTest
extends TestCase {
    public void testGeneratedInstanceTypes() throws IOException {
        byte[] byteData = SmosProduct.createTestProductData(SmosProduct.MIR_SCLF1C_FORMAT.getByteOrder());
        TracingIOHandler ioHandler = new TracingIOHandler((IOHandler)new ByteArrayIOHandler(byteData));
        DataContext context = SmosProduct.MIR_SCLF1C_FORMAT.createContext((IOHandler)ioHandler);
        CompoundData mirSclf1cData = context.getData();
        SequenceData snapshotList = mirSclf1cData.getSequence("Snapshot_List");
        CompoundData snapshotData = snapshotList.getCompound(0);
        SequenceData gridPointList = mirSclf1cData.getSequence("Grid_Point_List");
        CompoundData gridPointData = gridPointList.getCompound(0);
        SequenceData btDataList = gridPointData.getSequence("Bt_Data_List");
        CompoundData btData = btDataList.getCompound(0);
        InstanceTest.assertSame(VarCompound.class, mirSclf1cData.getClass());
        InstanceTest.assertSame(FixSequenceOfFixCollections.class, snapshotList.getClass());
        InstanceTest.assertSame(FixCompound.class, snapshotData.getClass());
        InstanceTest.assertSame(FixSequenceOfVarCollections.class, gridPointList.getClass());
        InstanceTest.assertSame(VarCompound.class, gridPointData.getClass());
        InstanceTest.assertSame(FixSequenceOfFixCollections.class, btDataList.getClass());
        InstanceTest.assertSame(FixCompound.class, btData.getClass());
    }

    public void testFixSequenceOfSimples() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ios.writeInt(2134);
        ios.writeInt(45);
        ios.writeInt(36134);
        ios.close();
        MemoryCacheImageInputStream iis = new MemoryCacheImageInputStream(new ByteArrayInputStream(baos.toByteArray()));
        DataContext context = new DataFormat(TypeBuilder.COMPOUND((String)"UNDEFINED", (CompoundMember[])new CompoundMember[0]), ByteOrder.LITTLE_ENDIAN).createContext((IOHandler)new ImageIOHandler((ImageInputStream)iis));
        SequenceType type = TypeBuilder.SEQUENCE((Type)SimpleType.INT, (int)3);
        FixSequenceOfSimples sequenceInstance = new FixSequenceOfSimples(context, null, type, 0L);
        InstanceTest.assertEquals((int)3, (int)sequenceInstance.getElementCount());
        InstanceTest.assertEquals((long)12L, (long)sequenceInstance.getSize());
        InstanceTest.assertEquals((boolean)false, (boolean)sequenceInstance.isDataAccessible());
        sequenceInstance.makeDataAccessible();
        InstanceTest.assertEquals((boolean)true, (boolean)sequenceInstance.isDataAccessible());
        InstanceTest.assertEquals((int)2134, (int)sequenceInstance.getInt(0));
        InstanceTest.assertEquals((int)45, (int)sequenceInstance.getInt(1));
        InstanceTest.assertEquals((int)36134, (int)sequenceInstance.getInt(2));
    }

    public void testFixCompound() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ios.writeInt(33);
        ios.writeInt(55);
        ios.writeFloat(27.88f);
        ios.close();
        CompoundType type = TypeBuilder.COMPOUND((String)"compoundTestType", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"a", (Type)SimpleType.UINT), TypeBuilder.MEMBER((String)"b", (Type)SimpleType.FLOAT)});
        InstanceTest.assertFalse((boolean)FixCompound.isCompoundTypeWithinSizeLimit((CompoundType)type, (long)7L));
        InstanceTest.assertTrue((boolean)FixCompound.isCompoundTypeWithinSizeLimit((CompoundType)type, (long)8L));
        InstanceTest.assertTrue((boolean)FixCompound.isCompoundTypeWithinSizeLimit((CompoundType)type, (long)9L));
        byte[] byteData = baos.toByteArray();
        InstanceTest.assertEquals((int)12, (int)byteData.length);
        DataContext context = new DataFormat(type, ByteOrder.LITTLE_ENDIAN).createContext((IOHandler)new ByteArrayIOHandler(byteData));
        CompoundInstance compoundInstance = InstanceFactory.createCompound((DataContext)context, null, (CompoundType)type, (long)4L, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        InstanceTest.assertSame(FixCompound.class, compoundInstance.getClass());
        InstanceTest.assertEquals((int)2, (int)compoundInstance.getElementCount());
        InstanceTest.assertEquals((long)8L, (long)compoundInstance.getSize());
        InstanceTest.assertEquals((long)4L, (long)compoundInstance.getPosition());
        InstanceTest.assertEquals((Object)type, (Object)compoundInstance.getType());
        InstanceTest.assertEquals((boolean)true, (boolean)compoundInstance.isSizeResolved());
        InstanceTest.assertEquals((int)55, (int)compoundInstance.getInt(0));
        InstanceTest.assertEquals((float)27.88f, (float)compoundInstance.getFloat(1), (float)1.0E-5f);
    }

    public void testFixCompoundOfFixCompounds() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        ios.writeDouble(17.0);
        ios.writeDouble(11.0);
        ios.writeDouble(19.0);
        ios.writeDouble(67.0);
        ios.close();
        CompoundType complexType = TypeBuilder.COMPOUND((String)"Complex", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"x", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"y", (Type)TypeBuilder.DOUBLE)});
        CompoundType type = TypeBuilder.COMPOUND((String)"compoundTestType", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"x", (Type)SimpleType.DOUBLE), TypeBuilder.MEMBER((String)"y", (Type)SimpleType.DOUBLE), TypeBuilder.MEMBER((String)"z", (Type)complexType)});
        InstanceTest.assertFalse((boolean)FixCompound.isCompoundTypeWithinSizeLimit((CompoundType)type, (long)31L));
        InstanceTest.assertTrue((boolean)FixCompound.isCompoundTypeWithinSizeLimit((CompoundType)type, (long)32L));
        InstanceTest.assertTrue((boolean)FixCompound.isCompoundTypeWithinSizeLimit((CompoundType)type, (long)33L));
        byte[] byteData = baos.toByteArray();
        InstanceTest.assertEquals((int)32, (int)byteData.length);
        DataContext context = new DataFormat(type, ByteOrder.LITTLE_ENDIAN).createContext((IOHandler)new ByteArrayIOHandler(byteData));
        CompoundInstance compoundInstance = InstanceFactory.createCompound((DataContext)context, null, (CompoundType)type, (long)0L, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        InstanceTest.assertSame(FixCompound.class, compoundInstance.getClass());
        InstanceTest.assertEquals((int)3, (int)compoundInstance.getElementCount());
        InstanceTest.assertEquals((long)32L, (long)compoundInstance.getSize());
        InstanceTest.assertEquals((long)0L, (long)compoundInstance.getPosition());
        InstanceTest.assertEquals((Object)type, (Object)compoundInstance.getType());
        InstanceTest.assertEquals((boolean)true, (boolean)compoundInstance.isSizeResolved());
        InstanceTest.assertEquals((double)11.0, (double)compoundInstance.getDouble(1), (double)0.0);
        InstanceTest.assertEquals((double)19.0, (double)compoundInstance.getCompound(2).getDouble(0), (double)0.0);
        InstanceTest.assertEquals((double)67.0, (double)compoundInstance.getCompound(2).getDouble(1), (double)0.0);
        CompoundData complexData = compoundInstance.getCompound(2);
        complexData.setDouble(0, 67.0);
        complexData.setDouble(0, 19.0);
    }

    public void testVarCompound() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(ByteOrder.BIG_ENDIAN);
        ios.writeInt(3);
        ios.writeDouble(111.1);
        ios.writeDouble(222.2);
        ios.writeDouble(333.3);
        ios.close();
        CompoundType type = TypeBuilder.COMPOUND((String)"compoundTestType", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"count", (Type)SimpleType.INT), TypeBuilder.MEMBER((String)"list", (Type)TypeBuilder.VAR_SEQUENCE((Type)SimpleType.DOUBLE, (String)"count"))});
        DataFormat format = new DataFormat(type, ByteOrder.BIG_ENDIAN);
        InstanceTest.assertFalse((boolean)FixCompound.isCompoundTypeWithinSizeLimit((CompoundType)type, (long)4L));
        InstanceTest.assertFalse((boolean)FixCompound.isCompoundTypeWithinSizeLimit((CompoundType)type, (long)10L));
        InstanceTest.assertFalse((boolean)FixCompound.isCompoundTypeWithinSizeLimit((CompoundType)type, (long)10000L));
        byte[] byteData = baos.toByteArray();
        InstanceTest.assertEquals((int)28, (int)byteData.length);
        DataContext context = format.createContext((IOHandler)new ByteArrayIOHandler(byteData));
        CompoundData compoundData = context.getData();
        InstanceTest.assertTrue((boolean)(compoundData instanceof CompoundInstance));
        CompoundInstance compoundInstance = (CompoundInstance)compoundData;
        InstanceTest.assertSame(VarCompound.class, compoundInstance.getClass());
        InstanceTest.assertEquals((int)2, (int)compoundInstance.getMemberCount());
        InstanceTest.assertFalse((boolean)compoundInstance.isSizeResolved());
        SequenceData sequenceData = compoundInstance.getSequence(1);
        InstanceTest.assertSame(FixSequenceOfSimples.class, sequenceData.getClass());
        compoundInstance.resolveSize();
        InstanceTest.assertTrue((boolean)compoundInstance.isSizeResolved());
        InstanceTest.assertTrue((compoundInstance.getSize() > 0L ? 1 : 0) != 0);
        InstanceTest.assertNotNull((Object)sequenceData);
        InstanceTest.assertEquals((int)3, (int)sequenceData.getElementCount());
        InstanceTest.assertEquals((double)111.1, (double)sequenceData.getDouble(0), (double)1.0E-10);
        InstanceTest.assertEquals((double)222.2, (double)sequenceData.getDouble(1), (double)1.0E-10);
        InstanceTest.assertEquals((double)333.3, (double)sequenceData.getDouble(2), (double)1.0E-10);
    }

    public void testFixSequenceOfFixCollections() throws IOException {
        int n = 11;
        CompoundType type = TypeBuilder.COMPOUND((String)"U", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"A", (Type)TypeBuilder.INT), TypeBuilder.MEMBER((String)"B", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.COMPOUND((String)"P", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"X", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"Y", (Type)TypeBuilder.DOUBLE)}), (int)11)), TypeBuilder.MEMBER((String)"C", (Type)TypeBuilder.INT)});
        InstanceTest.assertTrue((boolean)type.isSizeKnown());
        InstanceTest.assertEquals((int)184, (int)type.getSize());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(type.getSize());
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.writeInt(12345678);
        for (int i = 0; i < 11; ++i) {
            ios.writeDouble(20.0 + 0.1 * (double)i);
            ios.writeDouble(40.0 + 0.1 * (double)i);
        }
        ios.writeInt(87654321);
        ios.close();
        byte[] byteData = baos.toByteArray();
        InstanceTest.assertEquals((int)184, (int)byteData.length);
        DataContext context = new DataFormat(type).createContext((IOHandler)new ByteArrayIOHandler(byteData));
        CompoundData compoundData = context.getData();
        InstanceTest.assertSame(FixCompound.class, compoundData.getClass());
        InstanceTest.assertSame(FixSequenceOfFixCollections.class, compoundData.getSequence(1).getClass());
        InstanceTest.assertSame(FixCompound.class, compoundData.getSequence(1).getCompound(0).getClass());
        InstanceTest.assertEquals((int)12345678, (int)compoundData.getInt(0));
        for (int i = 0; i < 11; ++i) {
            InstanceTest.assertEquals((String)("i=" + i), (double)(20.0 + 0.1 * (double)i), (double)compoundData.getSequence(1).getCompound(i).getDouble(0), (double)1.0E-10);
            InstanceTest.assertEquals((String)("i=" + i), (double)(40.0 + 0.1 * (double)i), (double)compoundData.getSequence(1).getCompound(i).getDouble(1), (double)1.0E-10);
        }
        InstanceTest.assertEquals((int)87654321, (int)compoundData.getInt(2));
    }

    public void testFixSequenceOfVarCollections() throws IOException {
        int ni = 2;
        int nj = 3;
        CompoundType pointType = TypeBuilder.COMPOUND((String)"Point", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"X", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"Y", (Type)TypeBuilder.DOUBLE)});
        VarSequenceType seqType1 = InstanceTest._SEQ((Type)pointType, 2);
        VarSequenceType seqType2 = InstanceTest._SEQ((Type)seqType1, 3);
        CompoundType type = TypeBuilder.COMPOUND((String)"C", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"M", (Type)seqType2)});
        DataFormat format = new DataFormat(type, ByteOrder.BIG_ENDIAN);
        InstanceTest.assertFalse((boolean)type.isSizeKnown());
        InstanceTest.assertEquals((int)-1, (int)type.getSize());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(96);
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(format.getByteOrder());
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 2; ++i) {
                ios.writeDouble(20.0 + 0.1 * (double)i + 0.2 * (double)j);
                ios.writeDouble(40.0 + 0.1 * (double)i + 0.2 * (double)j);
            }
        }
        ios.close();
        byte[] byteData = baos.toByteArray();
        InstanceTest.assertEquals((int)96, (int)byteData.length);
        DataContext context = format.createContext((IOHandler)new ByteArrayIOHandler(byteData));
        CompoundData compoundData = context.getData();
        InstanceTest.assertSame(VarCompound.class, compoundData.getClass());
        InstanceTest.assertSame(FixSequenceOfVarCollections.class, compoundData.getSequence(0).getClass());
        InstanceTest.assertSame(FixSequenceOfFixCollections.class, compoundData.getSequence(0).getSequence(0).getClass());
        InstanceTest.assertSame(FixCompound.class, compoundData.getSequence(0).getSequence(0).getCompound(0).getClass());
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 2; ++i) {
                InstanceTest.assertEquals((String)("i=" + i + ",j=" + j), (double)(20.0 + 0.1 * (double)i + 0.2 * (double)j), (double)compoundData.getSequence(0).getSequence(j).getCompound(i).getDouble(0), (double)1.0E-10);
                InstanceTest.assertEquals((String)("i=" + i + ",j=" + j), (double)(40.0 + 0.1 * (double)i + 0.2 * (double)j), (double)compoundData.getSequence(0).getSequence(j).getCompound(i).getDouble(1), (double)1.0E-10);
            }
        }
    }

    public void testNestedFixSequenceOfVarCollections() throws IOException {
        int ni = 4;
        int nj = 2;
        int nk = 3;
        VarSequenceType seqType0 = InstanceTest._SEQ((Type)TypeBuilder.DOUBLE, 4);
        CompoundType pointType = TypeBuilder.COMPOUND((String)"Point", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Coords", (Type)seqType0)});
        VarSequenceType seqType1 = InstanceTest._SEQ((Type)pointType, 2);
        VarSequenceType seqType2 = InstanceTest._SEQ((Type)seqType1, 3);
        CompoundType type = TypeBuilder.COMPOUND((String)"Polygon", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"PointList", (Type)seqType2)});
        DataFormat format = new DataFormat(type, ByteOrder.BIG_ENDIAN);
        InstanceTest.assertFalse((boolean)type.isSizeKnown());
        InstanceTest.assertEquals((int)-1, (int)type.getSize());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(192);
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        ios.setByteOrder(format.getByteOrder());
        for (int k = 0; k < 3; ++k) {
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < 4; ++i) {
                    ios.writeDouble(10.0 * (double)i + 0.1 * (double)j + 0.2 * (double)k);
                }
            }
        }
        ios.close();
        byte[] byteData = baos.toByteArray();
        InstanceTest.assertEquals((int)192, (int)byteData.length);
        DataContext context = format.createContext((IOHandler)new ByteArrayIOHandler(byteData));
        CompoundData compoundData = context.getData();
        InstanceTest.assertSame(VarCompound.class, compoundData.getClass());
        SequenceData pointListData = compoundData.getSequence("PointList");
        InstanceTest.assertSame(FixSequenceOfVarCollections.class, pointListData.getClass());
        SequenceData pointListDataSeq0 = pointListData.getSequence(0);
        InstanceTest.assertSame(FixSequenceOfVarCollections.class, pointListDataSeq0.getClass());
        CompoundData pointListDataSeq0Comp0 = pointListDataSeq0.getCompound(0);
        InstanceTest.assertSame(VarCompound.class, pointListDataSeq0Comp0.getClass());
        SequenceData pointListDataSeq0Comp0Coords = pointListDataSeq0Comp0.getSequence("Coords");
        InstanceTest.assertSame(FixSequenceOfSimples.class, pointListDataSeq0Comp0Coords.getClass());
        for (int k = 0; k < 3; ++k) {
            SequenceData kData = pointListData.getSequence(k);
            for (int j = 0; j < 2; ++j) {
                CompoundData kjData = kData.getCompound(j);
                SequenceData coordsData = kjData.getSequence("Coords");
                for (int i = 0; i < 4; ++i) {
                    InstanceTest.assertEquals((String)("i=" + i + ",j=" + j + ",k=" + k), (double)(10.0 * (double)i + 0.1 * (double)j + 0.2 * (double)k), (double)coordsData.getDouble(i), (double)1.0E-10);
                }
            }
        }
    }

    static VarSequenceType _SEQ(Type elementType, final int elementCount) {
        return new VarElementCountSequenceType(elementType){

            protected int resolveElementCount(CollectionData parent) throws IOException {
                return elementCount;
            }
        };
    }
}

