/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import junit.framework.TestCase;

public class FileChannelTest
extends TestCase {
    private File file;
    private RandomAccessFile raf;

    protected void setUp() throws Exception {
        this.file = new File("test.dat");
        this.file.delete();
    }

    protected void tearDown() throws Exception {
        try {
            if (this.raf != null) {
                this.raf.close();
            }
        }
        finally {
            this.file.delete();
        }
    }

    public void testIt() throws IOException {
        this.raf = new RandomAccessFile(this.file, "rw");
        FileChannel channel = this.raf.getChannel();
        FileChannelTest.assertTrue((boolean)channel.isOpen());
        byte[] array = new byte[16];
        ByteBuffer buffer = ByteBuffer.wrap(array);
        buffer.putLong(123456789L);
        buffer.putLong(987654321L);
        buffer.rewind();
        int n = channel.write(buffer);
        channel.force(true);
        FileChannelTest.assertEquals((int)16, (int)n);
        FileChannelTest.assertEquals((long)16L, (long)channel.size());
        channel.close();
        this.raf = new RandomAccessFile(this.file, "r");
        channel = this.raf.getChannel();
        FileChannelTest.assertEquals((long)16L, (long)channel.size());
        array = new byte[16];
        buffer = ByteBuffer.wrap(array);
        channel.read(buffer);
        buffer.rewind();
        FileChannelTest.assertEquals((long)123456789L, (long)buffer.getLong());
        FileChannelTest.assertEquals((long)987654321L, (long)buffer.getLong());
        channel.close();
    }

    private static void readRawBytes() throws IOException {
        FileOutputStream fos = new FileOutputStream("test.dat");
        for (int i = 0; i < 65536; ++i) {
            fos.write((byte)i);
        }
        fos.close();
        FileInputStream fis = new FileInputStream("test.dat");
        FileChannel fc = fis.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate(15360);
        FileChannelTest.showStats("newly allocated read", fc, buffer);
        int bytesRead = fc.read(buffer);
        FileChannelTest.showStats("after first read", fc, buffer);
        FileChannelTest.showStats("before flip", fc, buffer);
        buffer.flip();
        FileChannelTest.showStats("after flip", fc, buffer);
        byte[] receive = new byte[1024];
        buffer.get(receive);
        FileChannelTest.showStats("after first get", fc, buffer);
        buffer.get(receive);
        FileChannelTest.showStats("after second get", fc, buffer);
        buffer.clear();
        FileChannelTest.showStats("after clear", fc, buffer);
        bytesRead = fc.read(buffer);
        FileChannelTest.showStats("after second read", fc, buffer);
        FileChannelTest.showStats("before flip", fc, buffer);
        buffer.flip();
        FileChannelTest.showStats("after flip", fc, buffer);
        fc.close();
    }

    private static void showStats(String where, FileChannel fc, Buffer b) throws IOException {
        System.out.println(where + " channelPosition=" + fc.position() + " position=" + b.position() + " limit=" + b.limit() + " remaining=" + b.remaining() + " capacity=" + b.capacity());
    }

    public static void main(String[] args) throws IOException {
        FileChannelTest.readRawBytes();
    }
}

