/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.smos;

import com.bc.ceres.binio.CompoundMember;
import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.TypeBuilder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.junit.Assert;

public class SmosProduct {
    public static final int[] BT_DATA_COUNTERS = new int[]{2, 4, 3, 6};
    public static final CompoundType SNAPSHOT_INFO_TYPE = TypeBuilder.COMPOUND((String)"Snapshot_Information", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Snapshot_Time", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.UINT, (int)3)), TypeBuilder.MEMBER((String)"Snapshot_ID", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"Snapshot_OBET", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.UBYTE, (int)8)), TypeBuilder.MEMBER((String)"Position", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.DOUBLE, (int)3)), TypeBuilder.MEMBER((String)"Velocity", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.DOUBLE, (int)3)), TypeBuilder.MEMBER((String)"Vector_Source", (Type)TypeBuilder.UBYTE), TypeBuilder.MEMBER((String)"Q0", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"Q1", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"Q2", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"Q3", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"TEC", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"Geomag_F", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"Geomag_D", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"Geomag_I", (Type)TypeBuilder.DOUBLE), TypeBuilder.MEMBER((String)"Sun_RA", (Type)TypeBuilder.FLOAT), TypeBuilder.MEMBER((String)"Sun_DEC", (Type)TypeBuilder.FLOAT), TypeBuilder.MEMBER((String)"Sun_BT", (Type)TypeBuilder.FLOAT), TypeBuilder.MEMBER((String)"Accuracy", (Type)TypeBuilder.FLOAT), TypeBuilder.MEMBER((String)"Radiometric_Accuracy", (Type)TypeBuilder.SEQUENCE((Type)TypeBuilder.FLOAT, (int)2))});
    public static final CompoundType F1C_BT_DATA_TYPE = TypeBuilder.COMPOUND((String)"Bt_Data", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Flags", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"BT_Value_Real", (Type)TypeBuilder.FLOAT), TypeBuilder.MEMBER((String)"BT_Value_Imag", (Type)TypeBuilder.FLOAT), TypeBuilder.MEMBER((String)"Radiometric_Accuracy_of_Pixel", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"Incidence_Angle", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"Azimuth_Angle", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"Faraday_Rotation_Angle", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"Geometric_Rotation_Angle", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"Snapshot_ID_of_Pixel", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"Footprint_Axis1", (Type)TypeBuilder.USHORT), TypeBuilder.MEMBER((String)"Footprint_Axis2", (Type)TypeBuilder.USHORT)});
    public static final CompoundType F1C_GRID_POINT_DATA_TYPE = TypeBuilder.COMPOUND((String)"Grid_Point_Data", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Grid_Point_ID", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"Grid_Point_Latitude", (Type)TypeBuilder.FLOAT), TypeBuilder.MEMBER((String)"Grid_Point_Longitude", (Type)TypeBuilder.FLOAT), TypeBuilder.MEMBER((String)"Grid_Point_Altitude", (Type)TypeBuilder.FLOAT), TypeBuilder.MEMBER((String)"Grid_Point_Mask", (Type)TypeBuilder.UBYTE), TypeBuilder.MEMBER((String)"BT_Data_Counter", (Type)TypeBuilder.UBYTE), TypeBuilder.MEMBER((String)"Bt_Data_List", (Type)TypeBuilder.VAR_SEQUENCE((Type)F1C_BT_DATA_TYPE, (String)"BT_Data_Counter"))});
    public static final CompoundType MIR_SCLF1C_TYPE = TypeBuilder.COMPOUND((String)"MIR_SCLF1C", (CompoundMember[])new CompoundMember[]{TypeBuilder.MEMBER((String)"Snapshot_Counter", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"Snapshot_List", (Type)TypeBuilder.VAR_SEQUENCE((Type)SNAPSHOT_INFO_TYPE, (String)"Snapshot_Counter")), TypeBuilder.MEMBER((String)"Grid_Point_Counter", (Type)TypeBuilder.UINT), TypeBuilder.MEMBER((String)"Grid_Point_List", (Type)TypeBuilder.VAR_SEQUENCE((Type)F1C_GRID_POINT_DATA_TYPE, (String)"Grid_Point_Counter"))});
    public static final DataFormat MIR_SCLF1C_FORMAT = new DataFormat(MIR_SCLF1C_TYPE, ByteOrder.LITTLE_ENDIAN);

    public static byte[] createTestProductData(ByteOrder byteOrder) throws IOException {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(baos);
        int size = 4;
        size += 3 * SNAPSHOT_INFO_TYPE.getSize();
        size += 4;
        for (int btDataCount : BT_DATA_COUNTERS) {
            size += 18;
            size += btDataCount * F1C_BT_DATA_TYPE.getSize();
        }
        ios.setByteOrder(byteOrder);
        ios.writeInt(3);
        for (i = 0; i < 3; ++i) {
            int[] snapshotTime = SmosProduct.getSnapshotTime(i);
            ios.writeInt(snapshotTime[0]);
            ios.writeInt(snapshotTime[1]);
            ios.writeInt(snapshotTime[2]);
            ios.writeInt(SmosProduct.getSnapshotId(i));
            ios.skipBytes(SNAPSHOT_INFO_TYPE.getSize() - 16);
        }
        ios.writeInt(BT_DATA_COUNTERS.length);
        for (i = 0; i < BT_DATA_COUNTERS.length; ++i) {
            int btDataCounter = BT_DATA_COUNTERS[i];
            ios.writeInt(SmosProduct.getGridPointId(i));
            ios.writeFloat(SmosProduct.getGridPointLatitude(i));
            ios.writeFloat(SmosProduct.getGridPointLongitude(i));
            ios.skipBytes(5);
            ios.writeByte(btDataCounter);
            for (int j = 0; j < btDataCounter; ++j) {
                ios.writeShort(SmosProduct.getBtDataFlags(j));
                ios.writeFloat(SmosProduct.getBtValueReal(j));
                ios.writeFloat(SmosProduct.getBtValueImag(j));
                ios.skipBytes(F1C_BT_DATA_TYPE.getSize() - 12);
                ios.writeShort(SmosProduct.getFootprintAxis2(j));
            }
        }
        ios.close();
        byte[] bytes = baos.toByteArray();
        Assert.assertEquals((long)size, (long)bytes.length);
        return bytes;
    }

    public static int[] getSnapshotTime(int i) {
        return new int[]{2540, i, 10000 + i};
    }

    public static int getSnapshotId(int i) {
        return 40000 + i;
    }

    public static int getGridPointId(int i) {
        return 968000 + i;
    }

    public static float getGridPointLatitude(int i) {
        return 36.0f + (float)i * 0.1f;
    }

    public static float getGridPointLongitude(int i) {
        return 13.0f + (float)i * 0.1f;
    }

    public static int getBtDataFlags(int j) {
        return 1 + j * 2;
    }

    public static float getBtValueReal(int j) {
        return 0.5f * (float)(j % 2);
    }

    public static float getBtValueImag(int j) {
        return 0.5f * (float)((1 - j) % 2);
    }

    public static int getFootprintAxis2(int j) {
        return j % 3;
    }
}

