/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.smos;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.DataContext;
import com.bc.ceres.binio.IOHandler;
import com.bc.ceres.binio.SequenceData;
import com.bc.ceres.binio.smos.SmosProduct;
import com.bc.ceres.binio.util.RandomAccessFileIOHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class SmosFileReader {
    public static void main(String[] args) throws IOException {
        System.out.println("Sequential access...");
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage before = memoryMXBean.getHeapMemoryUsage();
        System.out.println(before);
        File file = new File(args[0]);
        if (file.isDirectory()) {
            file = new File(file, file.getName() + ".DBL");
        }
        IOHandler handler = SmosFileReader.createIOHandler(file);
        DataContext context = SmosProduct.MIR_SCLF1C_FORMAT.createContext(handler);
        CompoundData data = context.getData();
        long snapshotCounter = data.getUInt("Snapshot_Counter");
        System.out.println("snapshotCounter = " + snapshotCounter);
        long gridPointCounter = data.getUInt("Grid_Point_Counter");
        System.out.println("gridPointCounter = " + gridPointCounter);
        SequenceData snapshotList = data.getSequence("Snapshot_List");
        for (int i = 0; i < snapshotList.getElementCount(); ++i) {
            CompoundData snapshotInfo = snapshotList.getCompound(i);
            long snapshotId = snapshotInfo.getUInt(1);
            SequenceData position = snapshotInfo.getSequence(3);
            SequenceData sequenceData = snapshotInfo.getSequence(4);
        }
        long t0 = System.currentTimeMillis();
        SmosFileReader.sequentialAccess(data);
        long t1 = System.currentTimeMillis();
        long dt = t1 - t0;
        System.out.println("dt = " + dt + " ms");
        MemoryUsage after = memoryMXBean.getHeapMemoryUsage();
        System.out.println(after);
        System.out.println();
        System.out.println("usage: " + (after.getUsed() - before.getUsed()));
        System.out.println("Random access...");
        before = memoryMXBean.getHeapMemoryUsage();
        System.out.println(before);
        t0 = System.currentTimeMillis();
        SmosFileReader.randomAccess(data);
        t1 = System.currentTimeMillis();
        dt = t1 - t0;
        System.out.println("dt = " + dt + " ms");
        after = memoryMXBean.getHeapMemoryUsage();
        System.out.println(after);
        System.out.println();
        System.out.println("usage: " + (after.getUsed() - before.getUsed()));
    }

    private static SequenceData sequentialAccess(CompoundData data) throws IOException {
        SequenceData gridPointList = data.getSequence("Grid_Point_List");
        for (int i = 0; i < gridPointList.getElementCount(); ++i) {
            CompoundData gridPointData = gridPointList.getCompound(i);
            long l = gridPointData.getUInt(0);
        }
        return gridPointList;
    }

    private static void randomAccess(CompoundData data) throws IOException {
        SequenceData gridPointList = data.getSequence("Grid_Point_List");
        for (int i = 0; i < gridPointList.getElementCount(); ++i) {
            int index = (int)(Math.random() * (double)gridPointList.getElementCount());
            CompoundData gridPointData = gridPointList.getCompound(index);
            long l = gridPointData.getUInt(0);
        }
    }

    private static IOHandler createIOHandler(File file) throws IOException {
        return new RandomAccessFileIOHandler(new RandomAccessFile(file, "r"));
    }
}

