/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.internal;

import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.internal.CompoundTypeImplTest;
import com.bc.ceres.binio.internal.GrowableSequenceTypeImpl;
import com.bc.ceres.binio.internal.SequenceTypeImpl;
import junit.framework.TestCase;

public class SequenceTypeImplTest
extends TestCase {
    public void testSimpleSequenceTypes() {
        SequenceTypeImplTest.testSequenceType((SequenceType)new SequenceTypeImpl((Type)SimpleType.BYTE, 512), (Type)SimpleType.BYTE, 512, "byte[512]", 512);
        SequenceTypeImplTest.testSequenceType((SequenceType)new SequenceTypeImpl((Type)SimpleType.UBYTE, 512), (Type)SimpleType.UBYTE, 512, "ubyte[512]", 512);
        SequenceTypeImplTest.testSequenceType((SequenceType)new SequenceTypeImpl((Type)SimpleType.SHORT, 512), (Type)SimpleType.SHORT, 512, "short[512]", 1024);
        SequenceTypeImplTest.testSequenceType((SequenceType)new SequenceTypeImpl((Type)SimpleType.USHORT, 512), (Type)SimpleType.USHORT, 512, "ushort[512]", 1024);
        SequenceTypeImplTest.testSequenceType((SequenceType)new SequenceTypeImpl((Type)SimpleType.INT, 512), (Type)SimpleType.INT, 512, "int[512]", 2048);
        SequenceTypeImplTest.testSequenceType((SequenceType)new SequenceTypeImpl((Type)SimpleType.UINT, 512), (Type)SimpleType.UINT, 512, "uint[512]", 2048);
        SequenceTypeImplTest.testSequenceType((SequenceType)new SequenceTypeImpl((Type)SimpleType.FLOAT, 512), (Type)SimpleType.FLOAT, 512, "float[512]", 2048);
        SequenceTypeImplTest.testSequenceType((SequenceType)new SequenceTypeImpl((Type)SimpleType.DOUBLE, 512), (Type)SimpleType.DOUBLE, 512, "double[512]", 4096);
        SequenceTypeImplTest.testSequenceType((SequenceType)new GrowableSequenceTypeImpl((Type)SimpleType.BYTE), (Type)SimpleType.BYTE, 0, "byte[]", 0);
        SequenceTypeImplTest.testSequenceType((SequenceType)new GrowableSequenceTypeImpl((Type)SimpleType.UBYTE), (Type)SimpleType.UBYTE, 0, "ubyte[]", 0);
        SequenceTypeImplTest.testSequenceType((SequenceType)new GrowableSequenceTypeImpl((Type)SimpleType.SHORT), (Type)SimpleType.SHORT, 0, "short[]", 0);
        SequenceTypeImplTest.testSequenceType((SequenceType)new GrowableSequenceTypeImpl((Type)SimpleType.USHORT), (Type)SimpleType.USHORT, 0, "ushort[]", 0);
        SequenceTypeImplTest.testSequenceType((SequenceType)new GrowableSequenceTypeImpl((Type)SimpleType.INT), (Type)SimpleType.INT, 0, "int[]", 0);
        SequenceTypeImplTest.testSequenceType((SequenceType)new GrowableSequenceTypeImpl((Type)SimpleType.UINT), (Type)SimpleType.UINT, 0, "uint[]", 0);
        SequenceTypeImplTest.testSequenceType((SequenceType)new GrowableSequenceTypeImpl((Type)SimpleType.FLOAT), (Type)SimpleType.FLOAT, 0, "float[]", 0);
        SequenceTypeImplTest.testSequenceType((SequenceType)new GrowableSequenceTypeImpl((Type)SimpleType.DOUBLE), (Type)SimpleType.DOUBLE, 0, "double[]", 0);
    }

    public void testComplexSequenceTypes() {
        GrowableSequenceTypeImpl sf = new GrowableSequenceTypeImpl((Type)SimpleType.FLOAT);
        GrowableSequenceTypeImpl ssf = new GrowableSequenceTypeImpl((Type)sf);
        GrowableSequenceTypeImpl sssf = new GrowableSequenceTypeImpl((Type)ssf);
        SequenceTypeImplTest.testSequenceType((SequenceType)sssf, (Type)ssf, 0, "float[][][]", 0);
        sf = new SequenceTypeImpl((Type)SimpleType.FLOAT, 32);
        ssf = new GrowableSequenceTypeImpl((Type)sf);
        sssf = new GrowableSequenceTypeImpl((Type)ssf);
        SequenceTypeImplTest.testSequenceType((SequenceType)sssf, (Type)ssf, 0, "float[32][][]", 0);
        sf = new SequenceTypeImpl((Type)SimpleType.FLOAT, 32);
        ssf = new SequenceTypeImpl((Type)sf, 43);
        sssf = new GrowableSequenceTypeImpl((Type)ssf);
        SequenceTypeImplTest.testSequenceType((SequenceType)sssf, (Type)ssf, 0, "float[32][43][]", 0);
        sf = new SequenceTypeImpl((Type)SimpleType.FLOAT, 32);
        ssf = new SequenceTypeImpl((Type)sf, 43);
        sssf = new SequenceTypeImpl((Type)ssf, 8);
        SequenceTypeImplTest.testSequenceType((SequenceType)sssf, (Type)ssf, 8, "float[32][43][8]", 44032);
        SequenceTypeImpl sr = new SequenceTypeImpl((Type)CompoundTypeImplTest.RECORD_TYPE, 300);
        SequenceTypeImplTest.testSequenceType((SequenceType)sr, (Type)CompoundTypeImplTest.RECORD_TYPE, 300, "Record[300]", 11400);
        sr = new GrowableSequenceTypeImpl((Type)CompoundTypeImplTest.RECORD_TYPE);
        SequenceTypeImplTest.testSequenceType((SequenceType)sr, (Type)CompoundTypeImplTest.RECORD_TYPE, 0, "Record[]", 0);
        SequenceTypeImpl sds = new SequenceTypeImpl((Type)CompoundTypeImplTest.DATASET_TYPE, 12);
        SequenceTypeImplTest.testSequenceType((SequenceType)sds, (Type)CompoundTypeImplTest.DATASET_TYPE, 12, "Dataset[12]", 48);
        sds = new GrowableSequenceTypeImpl((Type)CompoundTypeImplTest.DATASET_TYPE);
        SequenceTypeImplTest.testSequenceType((SequenceType)sds, (Type)CompoundTypeImplTest.DATASET_TYPE, 0, "Dataset[]", 0);
    }

    private static void testSequenceType(SequenceType sequenceType, Type expectedElementType, int expectedElementCount, String expectedName, int expectedSize) {
        SequenceTypeImplTest.assertEquals((String)expectedName, (String)sequenceType.getName());
        SequenceTypeImplTest.assertEquals((int)expectedSize, (int)sequenceType.getSize());
        SequenceTypeImplTest.assertSame((Object)expectedElementType, (Object)sequenceType.getElementType());
        SequenceTypeImplTest.assertEquals((int)expectedElementCount, (int)sequenceType.getElementCount());
        SequenceTypeImplTest.assertEquals((boolean)false, (boolean)sequenceType.isSimpleType());
        SequenceTypeImplTest.assertEquals((boolean)true, (boolean)sequenceType.isCollectionType());
        SequenceTypeImplTest.assertEquals((boolean)true, (boolean)sequenceType.isSequenceType());
        SequenceTypeImplTest.assertEquals((boolean)false, (boolean)sequenceType.isCompoundType());
    }
}

