/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.expr;

import com.bc.ceres.binio.CompoundData;
import com.bc.ceres.binio.SequenceType;
import com.bc.ceres.binio.SimpleType;
import com.bc.ceres.binio.Type;
import com.bc.ceres.binio.expr.AbstractExpression;
import com.bc.ceres.binio.expr.ChoiceExpr;
import com.bc.ceres.binio.expr.CompoundExpr;
import com.bc.ceres.binio.expr.Expression;
import com.bc.ceres.binio.expr.ExpressionBuilder;
import com.bc.ceres.binio.expr.SelectionExpr;
import com.bc.ceres.binio.expr.SequenceExpr;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionBuilderTest {
    @Test
    public void testSequence() throws IOException {
        SequenceExpr sequence = ExpressionBuilder.SEQ((Type)ExpressionBuilder.UINT, (int)42);
        Assert.assertEquals((Object)true, (Object)sequence.isConstant());
        Object result = sequence.evaluate(null);
        Assert.assertTrue((boolean)(result instanceof SequenceType));
        SequenceType sequenceType = (SequenceType)result;
        Assert.assertEquals((Object)SimpleType.UINT, (Object)sequenceType.getElementType());
        Assert.assertEquals((long)42L, (long)sequenceType.getElementCount());
    }

    @Test
    public void testChoice() throws IOException {
        ChoiceExpr choice = ExpressionBuilder.IF((Expression)ExpressionBuilder.CONSTANT((Object)true), (Type)ExpressionBuilder.INT, (Type)ExpressionBuilder.DOUBLE);
        Assert.assertEquals((Object)true, (Object)choice.isConstant());
        Object result = choice.evaluate(null);
        Assert.assertTrue((boolean)(result instanceof SimpleType));
        Assert.assertEquals((Object)SimpleType.INT, (Object)result);
        choice = ExpressionBuilder.IF((Expression)ExpressionBuilder.CONSTANT((Object)false), (Type)ExpressionBuilder.INT, (Type)ExpressionBuilder.DOUBLE);
        Assert.assertEquals((Object)true, (Object)choice.isConstant());
        result = choice.evaluate(null);
        Assert.assertTrue((boolean)(result instanceof SimpleType));
        Assert.assertEquals((Object)SimpleType.DOUBLE, (Object)result);
    }

    @Test
    public void testSelect() throws IOException {
        VariableExpr condition = new VariableExpr();
        SelectionExpr selection = ExpressionBuilder.SELECT((Expression)condition, (SelectionExpr.Case[])new SelectionExpr.Case[]{ExpressionBuilder.CASE((Object)"A", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.CASE((Object)"B", (Type)ExpressionBuilder.DOUBLE), ExpressionBuilder.DEFAULT((Type)ExpressionBuilder.INT)});
        condition.value = "A";
        Assert.assertEquals((Object)false, (Object)selection.isConstant());
        Object result = selection.evaluate(null);
        Assert.assertTrue((boolean)(result instanceof SimpleType));
        Assert.assertEquals((Object)SimpleType.FLOAT, (Object)result);
        condition.value = "B";
        Assert.assertEquals((Object)false, (Object)selection.isConstant());
        result = selection.evaluate(null);
        Assert.assertTrue((boolean)(result instanceof SimpleType));
        Assert.assertEquals((Object)SimpleType.DOUBLE, (Object)result);
        condition.value = "X";
        Assert.assertEquals((Object)false, (Object)selection.isConstant());
        result = selection.evaluate(null);
        Assert.assertTrue((boolean)(result instanceof SimpleType));
        Assert.assertEquals((Object)SimpleType.INT, (Object)result);
    }

    @Test
    public void testComplexExpressionTree() {
        CompoundExpr SNAPSHOT_INFO = ExpressionBuilder.COMP((String)"Snapshot_Information", (CompoundExpr.Member[])new CompoundExpr.Member[]{ExpressionBuilder.MEMBER((String)"Snapshot_Time", (Expression)ExpressionBuilder.SEQ((Type)ExpressionBuilder.UINT, (int)3)), ExpressionBuilder.MEMBER((String)"Snapshot_ID", (Type)ExpressionBuilder.UINT), ExpressionBuilder.MEMBER((String)"Snapshot_OBET", (Expression)ExpressionBuilder.SEQ((Type)ExpressionBuilder.UBYTE, (int)8)), ExpressionBuilder.MEMBER((String)"Position", (Expression)ExpressionBuilder.SEQ((Type)ExpressionBuilder.DOUBLE, (int)3)), ExpressionBuilder.MEMBER((String)"Velocity", (Expression)ExpressionBuilder.SEQ((Type)ExpressionBuilder.DOUBLE, (int)3)), ExpressionBuilder.MEMBER((String)"Vector_Source", (Type)ExpressionBuilder.UBYTE), ExpressionBuilder.MEMBER((String)"Q0", (Type)ExpressionBuilder.DOUBLE), ExpressionBuilder.MEMBER((String)"Q1", (Type)ExpressionBuilder.DOUBLE), ExpressionBuilder.MEMBER((String)"Q2", (Type)ExpressionBuilder.DOUBLE), ExpressionBuilder.MEMBER((String)"Q3", (Type)ExpressionBuilder.DOUBLE), ExpressionBuilder.MEMBER((String)"TEC", (Type)ExpressionBuilder.DOUBLE), ExpressionBuilder.MEMBER((String)"Geomag_F", (Type)ExpressionBuilder.DOUBLE), ExpressionBuilder.MEMBER((String)"Geomag_D", (Type)ExpressionBuilder.DOUBLE), ExpressionBuilder.MEMBER((String)"Geomag_I", (Type)ExpressionBuilder.DOUBLE), ExpressionBuilder.MEMBER((String)"Sun_RA", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.MEMBER((String)"Sun_DEC", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.MEMBER((String)"Sun_BT", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.MEMBER((String)"Accuracy", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.MEMBER((String)"Radiometric_Accuracy", (Expression)ExpressionBuilder.SEQ((Type)ExpressionBuilder.FLOAT, (int)2))});
        CompoundExpr BT_DATA = ExpressionBuilder.COMP((String)"Bt_Data", (CompoundExpr.Member[])new CompoundExpr.Member[]{ExpressionBuilder.MEMBER((String)"Flags", (Type)ExpressionBuilder.USHORT), ExpressionBuilder.MEMBER((String)"BT_Value_Real", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.MEMBER((String)"BT_Value_Imag", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.MEMBER((String)"Radiometric_Accuracy_of_Pixel", (Type)ExpressionBuilder.USHORT), ExpressionBuilder.MEMBER((String)"Incidence_Angle", (Type)ExpressionBuilder.USHORT), ExpressionBuilder.MEMBER((String)"Azimuth_Angle", (Type)ExpressionBuilder.USHORT), ExpressionBuilder.MEMBER((String)"Faraday_Rotation_Angle", (Type)ExpressionBuilder.USHORT), ExpressionBuilder.MEMBER((String)"Geometric_Rotation_Angle", (Type)ExpressionBuilder.USHORT), ExpressionBuilder.MEMBER((String)"Snapshot_ID_of_Pixel", (Type)ExpressionBuilder.UINT), ExpressionBuilder.MEMBER((String)"Footprint_Axis1", (Type)ExpressionBuilder.USHORT), ExpressionBuilder.MEMBER((String)"Footprint_Axis2", (Type)ExpressionBuilder.USHORT)});
        CompoundExpr GRID_POINT_DATA = ExpressionBuilder.COMP((String)"Grid_Point_Data", (CompoundExpr.Member[])new CompoundExpr.Member[]{ExpressionBuilder.MEMBER((String)"Grid_Point_ID", (Type)ExpressionBuilder.UINT), ExpressionBuilder.MEMBER((String)"Grid_Point_Latitude", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.MEMBER((String)"Grid_Point_Longitude", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.MEMBER((String)"Grid_Point_Altitude", (Type)ExpressionBuilder.FLOAT), ExpressionBuilder.MEMBER((String)"Grid_Point_Mask", (Type)ExpressionBuilder.UBYTE), ExpressionBuilder.MEMBER((String)"BT_Data_Counter", (Type)ExpressionBuilder.UBYTE), ExpressionBuilder.MEMBER((String)"Bt_Data_List", (Expression)ExpressionBuilder.SEQ((Expression)BT_DATA, (Expression)ExpressionBuilder.IREF((String)"BT_Data_Counter")))});
        CompoundExpr MIR_SCLD1C = ExpressionBuilder.COMP((String)"MIR_SCLD1C", (CompoundExpr.Member[])new CompoundExpr.Member[]{ExpressionBuilder.MEMBER((String)"Snapshot_Counter", (Type)ExpressionBuilder.UINT), ExpressionBuilder.MEMBER((String)"Snapshot_List", (Expression)ExpressionBuilder.SEQ((Expression)SNAPSHOT_INFO, (Expression)ExpressionBuilder.IREF((String)"Snapshot_Counter"))), ExpressionBuilder.MEMBER((String)"Grid_Point_Counter", (Type)ExpressionBuilder.UINT), ExpressionBuilder.MEMBER((String)"Grid_Point_List", (Expression)ExpressionBuilder.SEQ((Expression)GRID_POINT_DATA, (Expression)ExpressionBuilder.IREF((String)"Grid_Point_Counter")))});
    }

    private static class VariableExpr
    extends AbstractExpression {
        Object value;

        private VariableExpr() {
        }

        public boolean isConstant() {
            return false;
        }

        public Object evaluate(CompoundData context) throws IOException {
            return this.value;
        }
    }
}

