/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.binx;

import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.binx.BinX;
import com.bc.ceres.binio.binx.BinXException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.TestCase;

public class ArrayVariableTest
extends TestCase {
    public void testBinX() throws IOException, BinXException, URISyntaxException {
        URL resource = ((Object)((Object)this)).getClass().getResource("ArrayVariable.binXschema.xml");
        ArrayVariableTest.assertNotNull((Object)resource);
        URI uri = resource.toURI();
        BinX binx = new BinX();
        binx.setSingleDatasetStructInlined(true);
        binx.setArrayVariableInlined(true);
        DataFormat dataFormat = binx.readDataFormat(uri);
        ArrayVariableTest.assertTrue((boolean)(binx.getDefinition("Ernie") instanceof CompoundType));
        CompoundType ernieType = (CompoundType)binx.getDefinition("Ernie");
        ArrayVariableTest.assertEquals((String)"Ernie", (String)ernieType.getName());
        ArrayVariableTest.assertEquals((int)2, (int)ernieType.getMemberCount());
        ArrayVariableTest.assertEquals((String)"af32_Counter", (String)ernieType.getMember(0).getName());
        ArrayVariableTest.assertEquals((String)"af32", (String)ernieType.getMember(1).getName());
        ArrayVariableTest.assertEquals((String)"float[$af32_Counter]", (String)ernieType.getMember(1).getType().getName());
        ArrayVariableTest.assertTrue((boolean)(binx.getDefinition("Bert") instanceof CompoundType));
        CompoundType bertType = (CompoundType)binx.getDefinition("Bert");
        ArrayVariableTest.assertEquals((String)"Bert", (String)bertType.getName());
        ArrayVariableTest.assertEquals((int)3, (int)bertType.getMemberCount());
        ArrayVariableTest.assertEquals((String)"ai32_count", (String)bertType.getMember(0).getName());
        ArrayVariableTest.assertEquals((String)"ai32", (String)bertType.getMember(1).getName());
        ArrayVariableTest.assertEquals((String)"int[$ai32_count]", (String)bertType.getMember(1).getType().getName());
        ArrayVariableTest.assertEquals((String)"flags", (String)bertType.getMember(2).getName());
        CompoundType datasetType = dataFormat.getType();
        ArrayVariableTest.assertNotNull((Object)datasetType);
        ArrayVariableTest.assertEquals((String)"Dataset", (String)datasetType.getName());
        ArrayVariableTest.assertEquals((int)5, (int)datasetType.getMemberCount());
        ArrayVariableTest.assertEquals((String)"magic1", (String)datasetType.getMember(0).getName());
        ArrayVariableTest.assertEquals((String)"data1", (String)datasetType.getMember(1).getName());
        ArrayVariableTest.assertEquals((String)"magic2", (String)datasetType.getMember(2).getName());
        ArrayVariableTest.assertEquals((String)"data2", (String)datasetType.getMember(3).getName());
        ArrayVariableTest.assertEquals((String)"magic3", (String)datasetType.getMember(4).getName());
        ArrayVariableTest.assertSame((Object)ernieType, (Object)datasetType.getMember(1).getType());
        ArrayVariableTest.assertSame((Object)bertType, (Object)datasetType.getMember(3).getType());
    }

    public void testFormat() throws URISyntaxException, IOException, BinXException {
        URL resource = ((Object)((Object)this)).getClass().getResource("ArrayVariable.binXschema.xml");
        ArrayVariableTest.assertNotNull((Object)resource);
        URI uri = resource.toURI();
        BinX binx = new BinX();
        DataFormat format = binx.readDataFormat(uri, "ArrayVariableTest");
        ArrayVariableTest.assertEquals((String)"ArrayVariableTest", (String)format.getName());
        ArrayVariableTest.assertNotNull((Object)format.getType());
        ArrayVariableTest.assertEquals((String)"Dataset", (String)format.getType().getName());
        ArrayVariableTest.assertEquals((boolean)true, (boolean)format.isTypeDef("Ernie"));
        ArrayVariableTest.assertTrue((boolean)(format.getTypeDef("Ernie") instanceof CompoundType));
    }
}

