/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binio.binx;

import com.bc.ceres.binio.CompoundType;
import com.bc.ceres.binio.DataFormat;
import com.bc.ceres.binio.binx.BinX;
import com.bc.ceres.binio.binx.BinXException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.TestCase;

public class ArrayFixedTest
extends TestCase {
    public void testBinX() throws IOException, BinXException, URISyntaxException {
        URL resource = ((Object)((Object)this)).getClass().getResource("ArrayFixed.binXschema.xml");
        ArrayFixedTest.assertNotNull((Object)resource);
        URI uri = resource.toURI();
        BinX binx = new BinX();
        DataFormat dataFormat = binx.readDataFormat(uri);
        ArrayFixedTest.assertTrue((boolean)(binx.getDefinition("FixedFloat32ArrayType") instanceof CompoundType));
        CompoundType arrayCompoundType = (CompoundType)binx.getDefinition("FixedFloat32ArrayType");
        ArrayFixedTest.assertEquals((String)"FixedFloat32ArrayType", (String)arrayCompoundType.getName());
        ArrayFixedTest.assertEquals((int)1, (int)arrayCompoundType.getMemberCount());
        ArrayFixedTest.assertEquals((String)"af", (String)arrayCompoundType.getMember(0).getName());
        ArrayFixedTest.assertEquals((String)"float[8]", (String)arrayCompoundType.getMember(0).getType().getName());
        CompoundType datasetType = dataFormat.getType();
        ArrayFixedTest.assertNotNull((Object)datasetType);
        ArrayFixedTest.assertEquals((String)"Dataset", (String)datasetType.getName());
        ArrayFixedTest.assertEquals((int)3, (int)datasetType.getMemberCount());
        ArrayFixedTest.assertEquals((String)"magic1", (String)datasetType.getMember(0).getName());
        ArrayFixedTest.assertEquals((String)"data1", (String)datasetType.getMember(1).getName());
        ArrayFixedTest.assertEquals((String)"magic2", (String)datasetType.getMember(2).getName());
        ArrayFixedTest.assertSame((Object)arrayCompoundType, (Object)datasetType.getMember(1).getType());
    }

    public void testFormat() throws URISyntaxException, IOException, BinXException {
        URL resource = ((Object)((Object)this)).getClass().getResource("ArrayFixed.binXschema.xml");
        ArrayFixedTest.assertNotNull((Object)resource);
        URI uri = resource.toURI();
        BinX binx = new BinX();
        DataFormat format = binx.readDataFormat(uri, "ArrayFixedTest");
        ArrayFixedTest.assertEquals((String)"ArrayFixedTest", (String)format.getName());
        ArrayFixedTest.assertNotNull((Object)format.getType());
        ArrayFixedTest.assertEquals((String)"Dataset", (String)format.getType().getName());
        ArrayFixedTest.assertEquals((boolean)true, (boolean)format.isTypeDef("FixedFloat32ArrayType"));
        ArrayFixedTest.assertTrue((boolean)(format.getTypeDef("FixedFloat32ArrayType") instanceof CompoundType));
    }
}

