/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.validators;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.binding.validators.ValueSetValidator;
import org.junit.Test;

public class ValueSetValidatorTest {
    @Test
    public void testGoodNull() throws Exception {
        PropertyDescriptor descriptor = this.createPropertyDescriptor();
        descriptor.setNotNull(false);
        new ValueSetValidator(descriptor).validateValue(this.createProperty(descriptor), null);
    }

    @Test(expected=ValidationException.class)
    public void testBadNull() throws Exception {
        PropertyDescriptor descriptor = this.createPropertyDescriptor();
        descriptor.setNotNull(true);
        new ValueSetValidator(descriptor).validateValue(this.createProperty(descriptor), null);
    }

    @Test
    public void testGoodValues() throws Exception {
        PropertyDescriptor descriptor = this.createPropertyDescriptor();
        descriptor.setNotNull(false);
        ValueSetValidator validator = new ValueSetValidator(descriptor);
        validator.validateValue(this.createProperty(descriptor), (Object)"a");
        validator.validateValue(this.createProperty(descriptor), (Object)"b");
        validator.validateValue(this.createProperty(descriptor), (Object)"c");
    }

    @Test(expected=ValidationException.class)
    public void testBadValue() throws Exception {
        PropertyDescriptor descriptor = this.createPropertyDescriptor();
        descriptor.setNotNull(false);
        ValueSetValidator validator = new ValueSetValidator(descriptor);
        validator.validateValue(this.createProperty(descriptor), (Object)"d");
    }

    private Property createProperty(PropertyDescriptor descriptor) {
        return new Property(descriptor, (PropertyAccessor)new DefaultPropertyAccessor());
    }

    private PropertyDescriptor createPropertyDescriptor() {
        PropertyDescriptor descriptor = new PropertyDescriptor("x", String.class);
        descriptor.setValueSet(new ValueSet(new Object[]{"a", "b", "c"}));
        return descriptor;
    }
}

