/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.validators;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.validators.TypeValidator;
import junit.framework.TestCase;

public class TypeValidatorTest
extends TestCase {
    private boolean booleanValue;
    private char charValue;
    private byte byteValue;
    private short shortValue;
    private int intValue;
    private long longValue;
    private float floatValue;
    private double doubleValue;
    private String stringValue;
    private TestCase baseValue;
    private TypeValidatorTest derivedValue;

    public void testValidation() throws ValidationException {
        TypeValidator typeValidator = new TypeValidator();
        PropertyContainer propertyContainer = PropertyContainer.createObjectBacked((Object)((Object)this));
        String s = "booleanValue";
        this.testValid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testInvalid(typeValidator, propertyContainer, s, (byte)123);
        this.testInvalid(typeValidator, propertyContainer, s, (short)123);
        this.testInvalid(typeValidator, propertyContainer, s, 123);
        this.testInvalid(typeValidator, propertyContainer, s, 123L);
        this.testInvalid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testInvalid(typeValidator, propertyContainer, s, 123.0);
        this.testInvalid(typeValidator, propertyContainer, s, null);
        this.testInvalid(typeValidator, propertyContainer, s, "xyz");
        this.testInvalid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testInvalid(typeValidator, propertyContainer, s, (Object)this);
        s = "byteValue";
        this.testInvalid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testValid(typeValidator, propertyContainer, s, (byte)123);
        this.testInvalid(typeValidator, propertyContainer, s, (short)123);
        this.testInvalid(typeValidator, propertyContainer, s, 123);
        this.testInvalid(typeValidator, propertyContainer, s, 123L);
        this.testInvalid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testInvalid(typeValidator, propertyContainer, s, 123.0);
        this.testInvalid(typeValidator, propertyContainer, s, null);
        this.testInvalid(typeValidator, propertyContainer, s, "xyz");
        this.testInvalid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testInvalid(typeValidator, propertyContainer, s, (Object)this);
        s = "shortValue";
        this.testInvalid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testInvalid(typeValidator, propertyContainer, s, (byte)123);
        this.testValid(typeValidator, propertyContainer, s, (short)123);
        this.testInvalid(typeValidator, propertyContainer, s, 123);
        this.testInvalid(typeValidator, propertyContainer, s, 123L);
        this.testInvalid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testInvalid(typeValidator, propertyContainer, s, 123.0);
        this.testInvalid(typeValidator, propertyContainer, s, null);
        this.testInvalid(typeValidator, propertyContainer, s, "xyz");
        this.testInvalid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testInvalid(typeValidator, propertyContainer, s, (Object)this);
        s = "intValue";
        this.testInvalid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testInvalid(typeValidator, propertyContainer, s, (byte)123);
        this.testInvalid(typeValidator, propertyContainer, s, (short)123);
        this.testValid(typeValidator, propertyContainer, s, 123);
        this.testInvalid(typeValidator, propertyContainer, s, 123L);
        this.testInvalid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testInvalid(typeValidator, propertyContainer, s, 123.0);
        this.testInvalid(typeValidator, propertyContainer, s, null);
        this.testInvalid(typeValidator, propertyContainer, s, "xyz");
        this.testInvalid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testInvalid(typeValidator, propertyContainer, s, (Object)this);
        s = "longValue";
        this.testInvalid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testInvalid(typeValidator, propertyContainer, s, (byte)123);
        this.testInvalid(typeValidator, propertyContainer, s, (short)123);
        this.testInvalid(typeValidator, propertyContainer, s, 123);
        this.testValid(typeValidator, propertyContainer, s, 123L);
        this.testInvalid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testInvalid(typeValidator, propertyContainer, s, 123.0);
        this.testInvalid(typeValidator, propertyContainer, s, null);
        this.testInvalid(typeValidator, propertyContainer, s, "xyz");
        this.testInvalid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testInvalid(typeValidator, propertyContainer, s, (Object)this);
        s = "floatValue";
        this.testInvalid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testInvalid(typeValidator, propertyContainer, s, (byte)123);
        this.testInvalid(typeValidator, propertyContainer, s, (short)123);
        this.testInvalid(typeValidator, propertyContainer, s, 123);
        this.testInvalid(typeValidator, propertyContainer, s, 123L);
        this.testValid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testInvalid(typeValidator, propertyContainer, s, 123.0);
        this.testInvalid(typeValidator, propertyContainer, s, null);
        this.testInvalid(typeValidator, propertyContainer, s, "xyz");
        this.testInvalid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testInvalid(typeValidator, propertyContainer, s, (Object)this);
        s = "doubleValue";
        this.testInvalid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testInvalid(typeValidator, propertyContainer, s, (byte)123);
        this.testInvalid(typeValidator, propertyContainer, s, (short)123);
        this.testInvalid(typeValidator, propertyContainer, s, 123);
        this.testInvalid(typeValidator, propertyContainer, s, 123L);
        this.testInvalid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testValid(typeValidator, propertyContainer, s, 123.0);
        this.testInvalid(typeValidator, propertyContainer, s, null);
        this.testInvalid(typeValidator, propertyContainer, s, "xyz");
        this.testInvalid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testInvalid(typeValidator, propertyContainer, s, (Object)this);
        s = "stringValue";
        this.testInvalid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testInvalid(typeValidator, propertyContainer, s, (byte)123);
        this.testInvalid(typeValidator, propertyContainer, s, (short)123);
        this.testInvalid(typeValidator, propertyContainer, s, 123);
        this.testInvalid(typeValidator, propertyContainer, s, 123L);
        this.testInvalid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testInvalid(typeValidator, propertyContainer, s, 123.0);
        this.testValid(typeValidator, propertyContainer, s, null);
        this.testValid(typeValidator, propertyContainer, s, "xyz");
        this.testInvalid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testInvalid(typeValidator, propertyContainer, s, (Object)this);
        s = "baseValue";
        this.testInvalid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testInvalid(typeValidator, propertyContainer, s, (byte)123);
        this.testInvalid(typeValidator, propertyContainer, s, (short)123);
        this.testInvalid(typeValidator, propertyContainer, s, 123);
        this.testInvalid(typeValidator, propertyContainer, s, 123L);
        this.testInvalid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testInvalid(typeValidator, propertyContainer, s, 123.0);
        this.testValid(typeValidator, propertyContainer, s, null);
        this.testInvalid(typeValidator, propertyContainer, s, "xyz");
        this.testValid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testValid(typeValidator, propertyContainer, s, (Object)this);
        s = "derivedValue";
        this.testInvalid(typeValidator, propertyContainer, s, true);
        this.testInvalid(typeValidator, propertyContainer, s, Character.valueOf('{'));
        this.testInvalid(typeValidator, propertyContainer, s, (byte)123);
        this.testInvalid(typeValidator, propertyContainer, s, (short)123);
        this.testInvalid(typeValidator, propertyContainer, s, 123);
        this.testInvalid(typeValidator, propertyContainer, s, 123L);
        this.testInvalid(typeValidator, propertyContainer, s, Float.valueOf(123.0f));
        this.testInvalid(typeValidator, propertyContainer, s, 123.0);
        this.testValid(typeValidator, propertyContainer, s, null);
        this.testInvalid(typeValidator, propertyContainer, s, "xyz");
        this.testInvalid(typeValidator, propertyContainer, s, new TestCase(){});
        this.testValid(typeValidator, propertyContainer, s, (Object)this);
    }

    private void testInvalid(TypeValidator typeValidator, PropertyContainer propertyContainer, String name, Object invalidValue) {
        Property property = propertyContainer.getProperty(name);
        try {
            typeValidator.validateValue(property, invalidValue);
            TypeValidatorTest.fail((String)"ValidationException expected");
        }
        catch (ValidationException e) {
            try {
                property.setValue(invalidValue);
                TypeValidatorTest.fail((String)"ValidationException expected");
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
        }
    }

    private void testValid(TypeValidator typeValidator, PropertyContainer propertyContainer, String name, Object validValue) {
        Property property = propertyContainer.getProperty(name);
        try {
            typeValidator.validateValue(property, validValue);
            try {
                property.setValue(validValue);
            }
            catch (ValidationException e) {
                TypeValidatorTest.fail((String)"ValidationException not expected");
                e.printStackTrace();
            }
        }
        catch (ValidationException e) {
            TypeValidatorTest.fail((String)"ValidationException not expected");
            e.printStackTrace();
        }
    }
}

