/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding.dom;

import com.bc.ceres.binding.dom.DomElement;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.TestCase;

public abstract class AbstractDomElementTest
extends TestCase {
    protected abstract DomElement createDomElement(String var1);

    protected abstract DomElement createDomElement(String var1, String var2);

    public void testSingleElement() {
        DomElement element = this.createDomElement("x", "8");
        AbstractDomElementTest.assertEquals((String)"x", (String)element.getName());
        AbstractDomElementTest.assertEquals((String)"8", (String)element.getValue());
        AbstractDomElementTest.assertEquals((String)"<x>8</x>", (String)element.toXml());
        element = this.createDomElement("x", null);
        AbstractDomElementTest.assertEquals((String)"x", (String)element.getName());
        AbstractDomElementTest.assertEquals(null, (String)element.getValue());
        AbstractDomElementTest.assertEquals((String)"<x/>", (String)element.toXml());
        String name = "x";
        element = this.createDomElement("x");
        AbstractDomElementTest.assertEquals((String)"x", (String)element.getName());
        AbstractDomElementTest.assertEquals(null, (String)element.getValue());
        AbstractDomElementTest.assertEquals((String)"<x/>", (String)element.toXml());
    }

    public void testAttribues() {
        DomElement element = this.createDomElement("point");
        AbstractDomElementTest.assertNotNull((Object)element.getAttributeNames());
        AbstractDomElementTest.assertEquals((int)0, (int)element.getAttributeNames().length);
        element.setAttribute("x", "56");
        element.setAttribute("y", "24");
        element.setAttribute("z", "98");
        AbstractDomElementTest.assertNotNull((Object)element.getAttributeNames());
        HashSet<String> names = new HashSet<String>(Arrays.asList(element.getAttributeNames()));
        AbstractDomElementTest.assertEquals((int)3, (int)names.size());
        AbstractDomElementTest.assertTrue((boolean)names.contains("x"));
        AbstractDomElementTest.assertTrue((boolean)names.contains("y"));
        AbstractDomElementTest.assertTrue((boolean)names.contains("z"));
        AbstractDomElementTest.assertEquals((String)"56", (String)element.getAttribute("x"));
        AbstractDomElementTest.assertEquals((String)"24", (String)element.getAttribute("y"));
        AbstractDomElementTest.assertEquals((String)"98", (String)element.getAttribute("z"));
        AbstractDomElementTest.assertEquals(null, (String)element.getAttribute("w"));
        String xml = element.toXml();
        AbstractDomElementTest.assertTrue((boolean)xml.startsWith("<point "));
        AbstractDomElementTest.assertTrue((boolean)xml.contains("x=\"56\""));
        AbstractDomElementTest.assertTrue((boolean)xml.contains("y=\"24\""));
        AbstractDomElementTest.assertTrue((boolean)xml.contains("z=\"98\""));
        AbstractDomElementTest.assertTrue((boolean)xml.endsWith("/>"));
    }

    public void testChildren() {
        DomElement element = this.createDomElement("point");
        AbstractDomElementTest.assertEquals((int)0, (int)element.getChildCount());
        element.createChild("x").setValue("56");
        element.addChild(this.createDomElement("y", "24"));
        element.addChild(this.createDomElement("z", "98"));
        AbstractDomElementTest.assertNull((Object)element.getParent());
        AbstractDomElementTest.assertNotNull((Object)element.getChildCount());
        AbstractDomElementTest.assertEquals((int)3, (int)element.getChildCount());
        AbstractDomElementTest.assertNotNull((Object)element.getChild("x"));
        AbstractDomElementTest.assertNotNull((Object)element.getChild("y"));
        AbstractDomElementTest.assertNotNull((Object)element.getChild("z"));
        AbstractDomElementTest.assertNull((Object)element.getChild("w"));
        AbstractDomElementTest.assertEquals((String)"56", (String)((DomElement)element.getChild("x")).getValue());
        AbstractDomElementTest.assertEquals((String)"24", (String)((DomElement)element.getChild("y")).getValue());
        AbstractDomElementTest.assertEquals((String)"98", (String)((DomElement)element.getChild("z")).getValue());
        AbstractDomElementTest.assertSame((Object)element, (Object)((DomElement)element.getChild("x")).getParent());
        AbstractDomElementTest.assertSame((Object)element, (Object)((DomElement)element.getChild("y")).getParent());
        AbstractDomElementTest.assertSame((Object)element, (Object)((DomElement)element.getChild("z")).getParent());
        AbstractDomElementTest.assertEquals((String)"<point>\n<x>56</x>\n<y>24</y>\n<z>98</z>\n</point>", (String)element.toXml().replace("  ", ""));
    }

    public void testToXmlWithAttributesAndChildren() {
        DomElement element = this.createDomElement("layer");
        element.setAttribute("id", "a62b98ff5");
        element.createChild("name").setValue("ROI");
        element.createChild("visible").setValue("true");
        element.createChild("configuration");
        ((DomElement)element.getChild("configuration")).createChild("outlineColor").setValue("23,45,230");
        ((DomElement)element.getChild("configuration")).createChild("fillColor").setValue("123, 64,30");
        ((DomElement)element.getChild("configuration")).createChild("transparency").setValue("0.6");
        String xml = element.toXml();
        AbstractDomElementTest.assertEquals((String)"<layer id=\"a62b98ff5\">\n<name>ROI</name>\n<visible>true</visible>\n<configuration>\n<outlineColor>23,45,230</outlineColor>\n<fillColor>123, 64,30</fillColor>\n<transparency>0.6</transparency>\n</configuration>\n</layer>", (String)xml.replace("  ", ""));
    }
}

