/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.ConversionException;
import com.bc.ceres.binding.ValueRange;
import junit.framework.TestCase;

public class ValueRangeTest
extends TestCase {
    public void testParseFailures() {
        try {
            ValueRange.parseValueRange(null);
            ValueRangeTest.fail();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalArgumentException e) {
            ValueRangeTest.fail();
        }
        try {
            ValueRange.parseValueRange((String)"");
            ValueRangeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ValueRange.parseValueRange((String)"10,20");
            ValueRangeTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testParse() throws ConversionException {
        ValueRange valueRange = ValueRange.parseValueRange((String)"[10,20)");
        ValueRangeTest.assertEquals((double)10.0, (double)valueRange.getMin(), (double)1.0E-10);
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.hasMin());
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.isMinIncluded());
        ValueRangeTest.assertEquals((double)20.0, (double)valueRange.getMax(), (double)1.0E-10);
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.hasMax());
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.isMaxIncluded());
        valueRange = ValueRange.parseValueRange((String)"(-10,20]");
        ValueRangeTest.assertEquals((double)-10.0, (double)valueRange.getMin(), (double)1.0E-10);
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.isMinIncluded());
        ValueRangeTest.assertEquals((double)20.0, (double)valueRange.getMax(), (double)1.0E-10);
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.isMaxIncluded());
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.hasMin());
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.hasMax());
        valueRange = ValueRange.parseValueRange((String)"(*, 20]");
        ValueRangeTest.assertEquals((double)Double.NEGATIVE_INFINITY, (double)valueRange.getMin(), (double)1.0E-10);
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.hasMin());
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.isMinIncluded());
        ValueRangeTest.assertEquals((double)20.0, (double)valueRange.getMax(), (double)1.0E-10);
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.hasMax());
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.isMaxIncluded());
        valueRange = ValueRange.parseValueRange((String)"[-10,*]");
        ValueRangeTest.assertEquals((double)-10.0, (double)valueRange.getMin(), (double)1.0E-10);
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.isMinIncluded());
        ValueRangeTest.assertEquals((double)Double.POSITIVE_INFINITY, (double)valueRange.getMax(), (double)1.0E-10);
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.hasMax());
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.isMaxIncluded());
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.hasMin());
    }

    public void testContains() {
        ValueRange valueRange = new ValueRange(-1.5, 3.2, true, false);
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.contains(-1.6));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(-1.5));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(-1.4));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(3.1));
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.contains(3.2));
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.contains(3.3));
        valueRange = new ValueRange(-1.5, 3.2, false, true);
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.contains(-1.6));
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.contains(-1.5));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(-1.4));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(3.1));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(3.2));
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.contains(3.3));
        valueRange = new ValueRange(Double.NEGATIVE_INFINITY, 3.2, false, true);
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(-1.6));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(-1.5));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(-1.4));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(3.1));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(3.2));
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.contains(3.3));
        valueRange = new ValueRange(-1.5, Double.POSITIVE_INFINITY, false, true);
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.contains(-1.6));
        ValueRangeTest.assertEquals((boolean)false, (boolean)valueRange.contains(-1.5));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(-1.4));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(3.1));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(3.2));
        ValueRangeTest.assertEquals((boolean)true, (boolean)valueRange.contains(3.3));
    }
}

