/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.binding;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertyDescriptorFactory;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.converters.DoubleConverter;
import com.bc.ceres.binding.converters.IntegerConverter;
import com.bc.ceres.binding.converters.StringConverter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Field;
import java.util.HashMap;
import junit.framework.TestCase;

public class PropertyContainerTest
extends TestCase {
    public void testValueBackedValueContainer() throws ValidationException {
        PropertyContainer pc = PropertyContainer.createValueBacked(Pojo.class);
        MyPropertyChangeListener pcl = new MyPropertyChangeListener();
        pc.addPropertyChangeListener((PropertyChangeListener)pcl);
        this.testValueContainerModels(pc);
        PropertyContainerTest.assertEquals((String)"(name:null-->Ernie)(age:0-->16)(weight:0.0-->72.9)(code:\u0000-->#)", (String)pcl.trace);
    }

    public void testMapBackedValueContainer() throws ValidationException {
        HashMap map = new HashMap();
        PropertyContainer pc = PropertyContainer.createMapBacked(map, Pojo.class);
        PropertyContainerTest.assertEquals((int)0, (int)map.size());
        MyPropertyChangeListener pcl = new MyPropertyChangeListener();
        pc.addPropertyChangeListener((PropertyChangeListener)pcl);
        this.testValueContainerModels(pc);
        PropertyContainerTest.assertEquals((String)"(name:null-->Ernie)(age:0-->16)(weight:0.0-->72.9)(code:\u0000-->#)", (String)pcl.trace);
        PropertyContainerTest.assertEquals((Object)Character.valueOf('#'), map.get("code"));
        PropertyContainerTest.assertEquals((Object)"Ernie", map.get("name"));
        PropertyContainerTest.assertEquals((int)16, (int)((Integer)map.get("age")));
        PropertyContainerTest.assertEquals((double)72.9, (double)((Double)map.get("weight")), (double)1.0E-6);
    }

    public void testObjectBackedValueContainer() throws ValidationException {
        Pojo pojo = new Pojo();
        PropertyContainer pc = PropertyContainer.createObjectBacked((Object)pojo);
        MyPropertyChangeListener pcl = new MyPropertyChangeListener();
        pc.addPropertyChangeListener((PropertyChangeListener)pcl);
        this.testValueContainerModels(pc);
        PropertyContainerTest.assertEquals((String)"(name:Hermann-->Ernie)(age:59-->16)(weight:82.5-->72.9)(code:X-->#)", (String)pcl.trace);
        PropertyContainerTest.assertEquals((char)'#', (char)pojo.code);
        PropertyContainerTest.assertEquals((String)"Ernie", (String)pojo.name);
        PropertyContainerTest.assertEquals((int)16, (int)pojo.age);
        PropertyContainerTest.assertEquals((Object)72.9, (Object)pojo.weight);
    }

    private void testValueContainerModels(PropertyContainer vc) throws ValidationException {
        Property name = vc.getProperty("name");
        PropertyContainerTest.assertNotNull((Object)name);
        name.setValue((Object)"Ernie");
        PropertyContainerTest.assertEquals((String)"Ernie", (String)((String)name.getValue()));
        try {
            name.setValue((Object)3);
            PropertyContainerTest.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Property age = vc.getProperty("age");
        PropertyContainerTest.assertNotNull((Object)age);
        age.setValue((Object)16);
        PropertyContainerTest.assertEquals((int)16, (int)((Integer)age.getValue()));
        try {
            age.setValue((Object)"");
            PropertyContainerTest.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Property weight = vc.getProperty("weight");
        PropertyContainerTest.assertNotNull((Object)weight);
        weight.setValue((Object)72.9);
        PropertyContainerTest.assertEquals((double)72.9, (double)((Double)weight.getValue()), (double)1.0E-6);
        try {
            weight.setValue((Object)"");
            PropertyContainerTest.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Property code = vc.getProperty("code");
        PropertyContainerTest.assertNotNull((Object)code);
        code.setValue((Object)Character.valueOf('#'));
        PropertyContainerTest.assertEquals((char)'#', (char)((Character)code.getValue()).charValue());
        try {
            code.setValue((Object)2.5);
            PropertyContainerTest.fail((String)"ValidationException expected");
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        Property unknownModel = vc.getProperty("unknown");
        PropertyContainerTest.assertNull((Object)unknownModel);
    }

    public void testDefaultValues() throws ValidationException {
        MyValueDescriptorFactory valueDescriptorFactory = new MyValueDescriptorFactory();
        PropertyContainer container = PropertyContainer.createObjectBacked((Object)new Pojo(), (PropertyDescriptorFactory)valueDescriptorFactory);
        this.testCurrentValuesUsed(container);
        container.setDefaultValues();
        this.testDefaultValuesUsed(container);
        container = PropertyContainer.createValueBacked(Pojo.class, (PropertyDescriptorFactory)valueDescriptorFactory);
        this.testDefaultValuesUsed(container);
        container.setDefaultValues();
        this.testDefaultValuesUsed(container);
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        container = PropertyContainer.createMapBacked(map, Pojo.class, (PropertyDescriptorFactory)valueDescriptorFactory);
        PropertyContainerTest.assertEquals((int)0, (int)map.size());
        this.testInitialValuesUsed(container);
        container.setDefaultValues();
        PropertyContainerTest.assertEquals((int)4, (int)map.size());
        this.testDefaultValuesUsed(container);
        map = new HashMap(5);
        map.put("code", Character.valueOf('X'));
        map.put("name", "Hermann");
        map.put("age", 59);
        map.put("weight", 82.5);
        container = PropertyContainer.createMapBacked(map, Pojo.class, (PropertyDescriptorFactory)valueDescriptorFactory);
        PropertyContainerTest.assertEquals((int)4, (int)map.size());
        this.testCurrentValuesUsed(container);
        container.setDefaultValues();
        PropertyContainerTest.assertEquals((int)4, (int)map.size());
        this.testDefaultValuesUsed(container);
    }

    private void testInitialValuesUsed(PropertyContainer container) {
        PropertyContainerTest.assertEquals((char)'\u0000', (char)((Character)container.getValue("code")).charValue());
        PropertyContainerTest.assertEquals(null, (String)((String)container.getValue("name")));
        PropertyContainerTest.assertEquals((int)0, (int)((Integer)container.getValue("age")));
        PropertyContainerTest.assertEquals((double)0.0, (double)((Double)container.getValue("weight")), (double)1.0E-6);
        this.testUnhandledValues(container);
    }

    private void testCurrentValuesUsed(PropertyContainer container) {
        PropertyContainerTest.assertEquals((char)'X', (char)((Character)container.getValue("code")).charValue());
        PropertyContainerTest.assertEquals((String)"Hermann", (String)((String)container.getValue("name")));
        PropertyContainerTest.assertEquals((int)59, (int)((Integer)container.getValue("age")));
        PropertyContainerTest.assertEquals((double)82.5, (double)((Double)container.getValue("weight")), (double)1.0E-6);
        this.testUnhandledValues(container);
    }

    private void testDefaultValuesUsed(PropertyContainer container) {
        PropertyContainerTest.assertEquals((char)'Y', (char)((Character)container.getValue("code")).charValue());
        PropertyContainerTest.assertEquals((String)"Kurt", (String)((String)container.getValue("name")));
        PropertyContainerTest.assertEquals((int)42, (int)((Integer)container.getValue("age")));
        PropertyContainerTest.assertEquals((double)90.0, (double)((Double)container.getValue("weight")), (double)1.0E-6);
        this.testUnhandledValues(container);
    }

    private void testUnhandledValues(PropertyContainer container) {
        PropertyContainerTest.assertEquals((char)'\u0000', (char)((Character)container.getValue("codeNoDefault")).charValue());
        PropertyContainerTest.assertEquals(null, (String)((String)container.getValue("nameNoDefault")));
        PropertyContainerTest.assertEquals((int)0, (int)((Integer)container.getValue("ageNoDefault")));
        PropertyContainerTest.assertEquals((double)0.0, (double)((Double)container.getValue("weightNoDefault")), (double)1.0E-6);
    }

    public void testDerivedClassReflectionWorksInBaseClassInitializer() {
        PropertyContainerTest.assertEquals((int)42, (int)new B().x);
        PropertyContainerTest.assertEquals((int)99, (int)new B((int)99).x);
    }

    private static class MyValueDescriptorFactory
    implements PropertyDescriptorFactory {
        private MyValueDescriptorFactory() {
        }

        public PropertyDescriptor createValueDescriptor(Field field) {
            PropertyDescriptor descriptor = new PropertyDescriptor(field.getName(), field.getType());
            if (!field.getName().endsWith("NoDefault")) {
                if (field.getType().equals(String.class)) {
                    descriptor.setConverter((Converter)new StringConverter());
                    descriptor.setDefaultValue((Object)"Kurt");
                } else if (field.getType().equals(Character.TYPE)) {
                    descriptor.setConverter((Converter)new IntegerConverter());
                    descriptor.setDefaultValue((Object)Character.valueOf('Y'));
                } else if (field.getType().equals(Integer.TYPE)) {
                    descriptor.setConverter((Converter)new IntegerConverter());
                    descriptor.setDefaultValue((Object)42);
                } else if (field.getType().equals(Double.TYPE)) {
                    descriptor.setConverter((Converter)new DoubleConverter());
                    descriptor.setDefaultValue((Object)90.0);
                } else {
                    TestCase.fail((String)("Test is not prepared for " + field.getType() + " types."));
                }
            }
            return descriptor;
        }
    }

    private static class MyPropertyChangeListener
    implements PropertyChangeListener {
        String trace = "";

        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.trace = this.trace + "(" + evt.getPropertyName() + ":" + evt.getOldValue() + "-->" + evt.getNewValue() + ")";
        }
    }

    static class B
    extends A {
        int x;

        B() {
        }

        B(int x) {
            this.x = x;
        }
    }

    static abstract class A {
        A() {
            try {
                this.getClass().getDeclaredField("x").setInt(this, 42);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static class Pojo
    extends PojoBase {
        String name = "Hermann";
        int age = 59;
        double weight = 82.5;
        String nameNoDefault;
        int ageNoDefault;
        double weightNoDefault;

        Pojo() {
        }
    }

    static abstract class PojoBase {
        char code = (char)88;
        char codeNoDefault;

        PojoBase() {
        }
    }
}

