/*
 * Copyright (C) 2010 Brockmann Consult GmbH (info@brockmann-consult.de)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, see http://www.gnu.org/licenses/
 */

package com.bc.ceres.binding;

/**
 * A provider for property descriptors.
 *
 * @author Norman Fomferra
 * @since 0.14
 */
public interface PropertySetDescriptor {

    /**
     * Gets the names of all properties in the set.
     * @return The array of names of all properties in the set, or an empty array if the set is empty.
     */
    String[] getPropertyNames();

    /**
     * Gets a property descriptor for the given property name.
     *
     * @param propertyName The property name.
     * @return A property descriptor, or {@code null} if no such exists.
     */
    PropertyDescriptor getPropertyDescriptor(String propertyName);
}
