/*
 * Copyright (C) 2010 Brockmann Consult GmbH (info@brockmann-consult.de)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 3 of the License, or (at your option)
 * any later version.
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, see http://www.gnu.org/licenses/
 */

package org.esa.smos.dataio.smos;

import java.awt.geom.Area;

public interface CellValueProvider {

    Area getArea();

    long getCellIndex(double lon, double lat);

    byte getValue(long cellIndex, byte noDataValue);

    short getValue(long cellIndex, short noDataValue);

    int getValue(long cellIndex, int noDataValue);

    float getValue(long cellIndex, float noDataValue);

    int getSnapshotId();

    void setSnapshotId(int snapshotId);
}
