/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.swing;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.binding.Binding;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.ComponentAdapter;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import com.bc.ceres.swing.binding.internal.AbstractButtonAdapter;
import com.bc.ceres.swing.binding.internal.SingleSelectionEditor;
import com.bc.ceres.swing.binding.internal.TextComponentAdapter;
import com.bc.ceres.swing.binding.internal.TextFieldEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.esa.smos.gui.ChooserFactory;
import org.esa.smos.gui.swing.ProductNodeRenderer;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.ui.AppContext;

public class GuiHelper {
    public static final String LAST_SOURCE_DIR_KEY = "org.esa.smos.export.sourceDir";
    public static final String LAST_TARGET_FILE_KEY = "org.esa.smos.export.targetFile";
    public static final String LAST_TARGET_DIR_KEY = "org.esa.smos.export.targetDir";

    public static JPanel createPanelWithBoxLayout() {
        JPanel mainPanel = new JPanel();
        BoxLayout layout = new BoxLayout(mainPanel, 1);
        mainPanel.setLayout(layout);
        return mainPanel;
    }

    public static TableLayout createTableLayout(int columnCount) {
        TableLayout layout = new TableLayout(columnCount);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTablePadding(3, 3);
        return layout;
    }

    public static TableLayout createWeightedTableLayout(int columnCount) {
        TableLayout layout = GuiHelper.createTableLayout(columnCount);
        layout.setTableWeightX(Double.valueOf(1.0));
        return layout;
    }

    public static void addSourceProductsButtons(JPanel sourceProductPanel, boolean productSelectionFeasible, BindingContext bindingContext) {
        JRadioButton useSelectedProductButton = new JRadioButton("Use selected SMOS product");
        JRadioButton useAllProductsInDirectoryButton = new JRadioButton("Use all SMOS products in directory:");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(useSelectedProductButton);
        buttonGroup.add(useAllProductsInDirectoryButton);
        HashMap<JRadioButton, Boolean> buttonGroupValueSet = new HashMap<JRadioButton, Boolean>();
        buttonGroupValueSet.put(useSelectedProductButton, true);
        buttonGroupValueSet.put(useAllProductsInDirectoryButton, false);
        bindingContext.bind("useSelectedProduct", buttonGroup, buttonGroupValueSet);
        bindingContext.bindEnabledState("sourceDirectory", true, "useSelectedProduct", (Object)false);
        bindingContext.bindEnabledState("openFileDialog", true, "useSelectedProduct", (Object)false);
        useSelectedProductButton.setEnabled(productSelectionFeasible);
        sourceProductPanel.add(useSelectedProductButton);
        sourceProductPanel.add(useAllProductsInDirectoryButton);
    }

    public static JComponent createFileEditorComponent(PropertyDescriptor descriptor, ChooserFactory cf, BindingContext bindingContext) {
        return GuiHelper.createFileEditorComponent(descriptor, cf, bindingContext, true);
    }

    public static JComponent createFileEditorComponent(PropertyDescriptor descriptor, ChooserFactory cf, BindingContext bindingContext, boolean bindEtcButton) {
        JTextField textField = new JTextField();
        textField.setColumns(30);
        TextComponentAdapter adapter = new TextComponentAdapter((JTextComponent)textField);
        Binding binding = bindingContext.bind(descriptor.getName(), (ComponentAdapter)adapter);
        JButton etcButton = new JButton("...");
        Dimension size = new Dimension(26, 16);
        etcButton.setPreferredSize(size);
        etcButton.setMinimumSize(size);
        if (bindEtcButton) {
            bindingContext.bind("openFileDialog", (ComponentAdapter)new AbstractButtonAdapter((AbstractButton)etcButton));
        }
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)textField, "Center");
        panel.add((Component)etcButton, "East");
        ActionListener actionListener = actionEvent -> {
            JFileChooser chooser = cf.createChooser((File)binding.getPropertyValue());
            int state = chooser.showDialog(panel, "Select");
            if (state == 0 && chooser.getSelectedFile() != null) {
                binding.setPropertyValue((Object)chooser.getSelectedFile());
            }
        };
        etcButton.addActionListener(actionListener);
        return panel;
    }

    public static File getDefaultSourceDirectory(AppContext appContext) {
        return GuiHelper.getFileFromProperties(appContext, LAST_SOURCE_DIR_KEY);
    }

    public static void setDefaultSourceDirectory(File sourceDirectory, AppContext appContext) {
        appContext.getPreferences().setPropertyString(LAST_SOURCE_DIR_KEY, sourceDirectory.getPath());
    }

    public static File getDefaultTargetDirectory(AppContext appContext) {
        return GuiHelper.getFileFromProperties(appContext, LAST_TARGET_DIR_KEY);
    }

    public static void setDefaultTargetDirectory(File targetDirectory, AppContext appContext) {
        appContext.getPreferences().setPropertyString(LAST_TARGET_DIR_KEY, targetDirectory.getPath());
    }

    private static File getFileFromProperties(AppContext appContext, String lastSourceDirKey) {
        String def = System.getProperty("user.home", ".");
        return new File(appContext.getPreferences().getPropertyString(lastSourceDirKey, def));
    }

    public static List<VectorDataNode> getGeometryNodes(Product selectedProduct) {
        ArrayList<VectorDataNode> geometryNodeList = new ArrayList<VectorDataNode>();
        ProductNodeGroup vectorDataGroup = selectedProduct.getVectorDataGroup();
        for (VectorDataNode node : (VectorDataNode[])vectorDataGroup.toArray((ProductNode[])new VectorDataNode[vectorDataGroup.getNodeCount()])) {
            if (!node.getFeatureType().getTypeName().equals("org.esa.snap.Geometry") || node.getFeatureCollection().isEmpty()) continue;
            geometryNodeList.add(node);
        }
        return geometryNodeList;
    }

    public static void bindGeometryNodes(List<VectorDataNode> geometryNodes, PropertySet propertySet) throws ValidationException {
        PropertyDescriptor descriptor = propertySet.getDescriptor("geometry");
        descriptor.setNotNull(false);
        descriptor.setNotEmpty(false);
        descriptor.setValueSet(new ValueSet(geometryNodes.toArray()));
        propertySet.setValue("roiType", (Object)1);
        propertySet.getProperty("geometry").setValue((Object)geometryNodes.get(0));
    }

    public static JComboBox createGeometryNodeComboBox(PropertyDescriptor geometryDescriptor, BindingContext bindingContext) {
        PropertyEditorRegistry registry = PropertyEditorRegistry.getInstance();
        PropertyEditor selectionEditor = registry.getPropertyEditor(SingleSelectionEditor.class.getName());
        JComboBox comboBox = (JComboBox)selectionEditor.createEditorComponent(geometryDescriptor, bindingContext);
        comboBox.setRenderer(new ProductNodeRenderer());
        return comboBox;
    }

    public static Component createLatLonCoordinatePanel(String name, String displayName, int numColumns, PropertyContainer propertyContainer, BindingContext bindingContext) {
        PropertyEditor editor = PropertyEditorRegistry.getInstance().getPropertyEditor(TextFieldEditor.class.getName());
        JTextField textField = (JTextField)editor.createEditorComponent(propertyContainer.getDescriptor(name), bindingContext);
        JLabel nameLabel = new JLabel(displayName);
        JLabel unitLabel = new JLabel("\u00b0");
        nameLabel.setEnabled(textField.isEnabled());
        unitLabel.setEnabled(textField.isEnabled());
        textField.setColumns(numColumns);
        textField.addPropertyChangeListener("enabled", evt -> {
            Boolean enabled = (Boolean)evt.getNewValue();
            nameLabel.setEnabled(enabled);
            unitLabel.setEnabled(enabled);
        });
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(nameLabel);
        panel.add(textField);
        panel.add(unitLabel);
        return panel;
    }

    public static Component createLatLonPanel(PropertyContainer propertyContainer, BindingContext bindingContext) {
        TableLayout layout = GuiHelper.createTableLayout(3);
        JPanel areaPanel = new JPanel((LayoutManager)layout);
        JLabel emptyLabel = new JLabel(" ");
        areaPanel.add(emptyLabel);
        Component northPanel = GuiHelper.createLatLonCoordinatePanel("northBound", "North:", 4, propertyContainer, bindingContext);
        areaPanel.add(northPanel);
        areaPanel.add(emptyLabel);
        Component westPanel = GuiHelper.createLatLonCoordinatePanel("westBound", "West:", 5, propertyContainer, bindingContext);
        areaPanel.add(westPanel);
        areaPanel.add(emptyLabel);
        Component eastPanel = GuiHelper.createLatLonCoordinatePanel("eastBound", "East:", 5, propertyContainer, bindingContext);
        areaPanel.add(eastPanel);
        areaPanel.add(emptyLabel);
        Component southPanel = GuiHelper.createLatLonCoordinatePanel("southBound", "South:", 4, propertyContainer, bindingContext);
        areaPanel.add(southPanel);
        areaPanel.add(emptyLabel);
        return areaPanel;
    }

    public static void bindLonLatPanelToRoiType(int roiTypeId, BindingContext bindingContext) {
        bindingContext.bindEnabledState("northBound", true, "roiType", (Object)roiTypeId);
        bindingContext.bindEnabledState("southBound", true, "roiType", (Object)roiTypeId);
        bindingContext.bindEnabledState("eastBound", true, "roiType", (Object)roiTypeId);
        bindingContext.bindEnabledState("westBound", true, "roiType", (Object)roiTypeId);
    }
}

