/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.snapshot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.esa.smos.gui.SceneViewSelectionService;
import org.esa.smos.gui.SmosBox;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.ui.product.ProductSceneView;

public class SnapshotSelectionService {
    private final SceneViewSelectionService smosViewSelectionService;
    private final List<SelectionListener> selectionListenerList;
    private final Map<RasterDataNode, Long> snapshotIdMap;
    private final SceneViewSelectionService.SelectionListener smosViewSelectionListener;

    public SnapshotSelectionService(SceneViewSelectionService smosViewSelectionService) {
        this.smosViewSelectionService = smosViewSelectionService;
        this.selectionListenerList = new ArrayList<SelectionListener>();
        this.snapshotIdMap = new WeakHashMap<RasterDataNode, Long>();
        this.smosViewSelectionListener = (oldView, newView) -> {
            if (SmosBox.isL1cScienceSmosView(newView)) {
                Map<RasterDataNode, Long> map = this.snapshotIdMap;
                synchronized (map) {
                    Long newId = this.snapshotIdMap.get(newView.getRaster());
                    if (newId != null) {
                        this.fireSelectionChange(newView, newId);
                    } else {
                        this.fireSelectionChange(newView, -1L);
                    }
                }
            }
        };
        this.smosViewSelectionService.addSceneViewSelectionListener(this.smosViewSelectionListener);
    }

    public final synchronized void stop() {
        this.snapshotIdMap.clear();
        this.selectionListenerList.clear();
        this.smosViewSelectionService.removeSceneViewSelectionListener(this.smosViewSelectionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSelectedSnapshotId(RasterDataNode raster) {
        Long id;
        Map<RasterDataNode, Long> map = this.snapshotIdMap;
        synchronized (map) {
            id = this.snapshotIdMap.get(raster);
        }
        if (id != null) {
            return id;
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedSnapshotId(RasterDataNode raster, long id) {
        if (SmosBox.isL1cScienceSmosRaster(raster)) {
            if (id >= 0L) {
                Map<RasterDataNode, Long> map = this.snapshotIdMap;
                synchronized (map) {
                    this.snapshotIdMap.put(raster, id);
                }
            }
            Map<RasterDataNode, Long> map = this.snapshotIdMap;
            synchronized (map) {
                this.snapshotIdMap.remove(raster);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireSelectionChange(ProductSceneView newView, long newId) {
        SelectionListener[] selectionListenerArray = this.selectionListenerList;
        synchronized (this.selectionListenerList) {
            SelectionListener[] listeners = this.selectionListenerList.toArray(new SelectionListener[this.selectionListenerList.size()]);
            // ** MonitorExit[var5_3] (shouldn't be in output)
            for (SelectionListener listener : listeners) {
                listener.handleSnapshotIdChanged(newView, newId);
            }
            return;
        }
    }

    public static interface SelectionListener {
        public void handleSnapshotIdChanged(ProductSceneView var1, long var2);
    }
}

