/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.gridpoint;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.esa.smos.gui.gridpoint.ColumnProperty;
import org.esa.snap.ui.UIUtils;

class GridPointTableSelectionDialog
extends JDialog {
    private final HashMap<String, Boolean> columnSelectionMap;
    private boolean isCanceled;

    static GridPointTableSelectionDialog create(Frame frame, ColumnProperty[] columnProperties) {
        GridPointTableSelectionDialog dialog = new GridPointTableSelectionDialog(frame, columnProperties);
        UIUtils.centerComponent((Component)dialog, (Component)frame);
        return dialog;
    }

    HashMap<String, Boolean> getSelection() {
        return this.columnSelectionMap;
    }

    boolean isCanceled() {
        return this.isCanceled;
    }

    private GridPointTableSelectionDialog(Frame owner, ColumnProperty[] columnProperties) {
        super(owner, "Choose Colums to Display", true);
        this.setResizable(false);
        this.columnSelectionMap = new HashMap(columnProperties.length);
        for (ColumnProperty columnProperty : columnProperties) {
            this.columnSelectionMap.put(columnProperty.getColumnName(), columnProperty.isVisible());
        }
        this.createGui(columnProperties);
    }

    private void createGui(ColumnProperty[] columnProperties) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 20, 5, 20);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 25;
        panel.add((Component)new JLabel("Select the columns you want to display for this table"), gbc);
        gbc.gridy = 1;
        gbc.anchor = 10;
        panel.add((Component)this.createColumnNamesPane(columnProperties), gbc);
        gbc.gridy = 2;
        gbc.anchor = 22;
        panel.add((Component)this.createButtonPanel(), gbc);
        this.add(panel);
        this.pack();
    }

    private ScrollPane createColumnNamesPane(ColumnProperty[] columnProperties) {
        ScrollPane scrollPane = new ScrollPane();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 23;
        for (ColumnProperty columnProperty : columnProperties) {
            JCheckBox checkBox = new JCheckBox(columnProperty.getColumnName(), columnProperty.isVisible());
            checkBox.addActionListener(this::toggleColumnState);
            panel.add((Component)checkBox, gbc);
            ++gbc.gridy;
        }
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 23;
        scrollPane.add((Component)panel, gbc);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        return scrollPane;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(5, 20, 5, 20);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 22;
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> this.onOk());
        buttonPanel.add((Component)okButton, gbc);
        gbc.gridx = 1;
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> this.onCancel());
        buttonPanel.add((Component)cancelButton, gbc);
        return buttonPanel;
    }

    private void toggleColumnState(ActionEvent e) {
        boolean selected = ((JCheckBox)e.getSource()).isSelected();
        String columnName = e.getActionCommand();
        this.columnSelectionMap.put(columnName, selected);
    }

    private void onOk() {
        this.isCanceled = false;
        this.closeDialog();
    }

    private void onCancel() {
        this.isCanceled = true;
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

