/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.gridpoint;

import java.util.ArrayList;
import java.util.List;

public class GridPointSelectionService {
    private final List<SelectionListener> selectionListeners = new ArrayList<SelectionListener>();
    private int selectedPointId = -1;

    public synchronized void stop() {
        this.selectionListeners.clear();
        this.selectedPointId = -1;
    }

    public synchronized int getSelectedGridPointId() {
        return this.selectedPointId;
    }

    public synchronized void setSelectedGridPointId(int id) {
        int oldId = this.selectedPointId;
        if (oldId != id) {
            this.selectedPointId = id;
            this.fireSelectionChange(oldId, id);
        }
    }

    public synchronized void addGridPointSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public synchronized void removeGridPointSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    private void fireSelectionChange(int oldId, int newId) {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.handleGridPointSelectionChanged(oldId, newId);
        }
    }

    public static interface SelectionListener {
        public void handleGridPointSelectionChanged(int var1, int var2);
    }
}

