/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.gridpoint;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.dataio.smos.dddb.Dddb;
import org.esa.smos.dataio.smos.dddb.FlagDescriptor;
import org.esa.smos.gui.gridpoint.GridPointBtDataTopComponent;
import org.esa.snap.ui.product.ProductSceneView;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.labels.XYZToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.XYBlockRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.DefaultXYZDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleInsets;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="GridPointBtDataFlagmatrixTopComponent", iconBase="org/esa/smos/icons/SmosFlags.png", persistenceType=0)
public class GridPointBtDataFlagmatrixTopComponent
extends GridPointBtDataTopComponent {
    static final String DISPLAY_NAME = "SMOS L1C Flag-Matrix";
    private static final String SERIES_KEY = "Flags";
    private static final String DEFAULT_FLAG_DESCRIPTOR_IDENTIFIER = "DBL_SM_XXXX_MIR_XXXF1C_0400_flags";
    private JFreeChart chart;
    private DefaultXYZDataset dataset;
    private XYPlot plot;
    private ChartPanel chartPanel;
    private FlagDescriptor[] flagDescriptors;
    private XYBlockRenderer renderer;

    public GridPointBtDataFlagmatrixTopComponent() {
        this.setDisplayName(DISPLAY_NAME);
    }

    @Override
    protected JComponent createGridPointComponent() {
        this.dataset = new DefaultXYZDataset();
        NumberAxis xAxis = new NumberAxis("Record #");
        xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        xAxis.setAutoRangeIncludesZero(false);
        xAxis.setLowerMargin(0.0);
        xAxis.setUpperMargin(0.0);
        List flagDescriptorList = Dddb.getInstance().getFlagDescriptors(DEFAULT_FLAG_DESCRIPTOR_IDENTIFIER).asList();
        this.flagDescriptors = flagDescriptorList.toArray(new FlagDescriptor[flagDescriptorList.size()]);
        String[] flagNames = this.createFlagNames(this.flagDescriptors);
        NumberAxis yAxis = this.createRangeAxis(flagNames);
        LookupPaintScale paintScale = new LookupPaintScale(0.0, 4.0, (Paint)Color.WHITE);
        paintScale.add(0.0, (Paint)Color.BLACK);
        paintScale.add(1.0, (Paint)Color.RED);
        paintScale.add(2.0, (Paint)Color.GREEN);
        paintScale.add(3.0, (Paint)Color.BLUE);
        paintScale.add(4.0, (Paint)Color.YELLOW);
        this.renderer = new XYBlockRenderer();
        this.renderer.setPaintScale((PaintScale)paintScale);
        this.renderer.setBaseToolTipGenerator((XYToolTipGenerator)new FlagToolTipGenerator(flagNames));
        this.plot = new XYPlot((XYDataset)this.dataset, (ValueAxis)xAxis, (ValueAxis)yAxis, (XYItemRenderer)this.renderer);
        this.plot.setBackgroundPaint((Paint)Color.LIGHT_GRAY);
        this.plot.setDomainGridlinePaint((Paint)Color.WHITE);
        this.plot.setRangeGridlinePaint((Paint)Color.WHITE);
        this.plot.setForegroundAlpha(0.5f);
        this.plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        this.plot.setNoDataMessage("No data");
        this.chart = new JFreeChart(null, (Plot)this.plot);
        this.chart.removeLegend();
        this.chartPanel = new ChartPanel(this.chart);
        return this.chartPanel;
    }

    @Override
    protected void updateClientComponent(ProductSceneView smosView) {
        boolean enabled = smosView != null;
        SmosReader smosReader = null;
        if (enabled && ((smosReader = this.getSelectedSmosReader()) == null || !smosReader.canSupplyGridPointBtData())) {
            enabled = false;
        }
        this.chartPanel.setEnabled(enabled);
        if (enabled) {
            this.flagDescriptors = smosReader.getBtFlagDescriptors();
            String[] flagNames = this.createFlagNames(this.flagDescriptors);
            this.renderer.setBaseToolTipGenerator((XYToolTipGenerator)new FlagToolTipGenerator(flagNames));
            NumberAxis rangeAxis = this.createRangeAxis(flagNames);
            this.plot.setRangeAxis((ValueAxis)rangeAxis);
        }
    }

    @Override
    protected void updateGridPointBtDataComponent(GridPointBtDataset ds) {
        this.dataset.removeSeries((Comparable)((Object)SERIES_KEY));
        int iq = ds.getFlagBandIndex();
        if (iq != -1) {
            Number[][] dsData = ds.getData();
            int m = dsData.length;
            int n = this.flagDescriptors.length;
            double[][] data = new double[3][n * m];
            for (int x = 0; x < m; ++x) {
                int flags = dsData[x][iq].intValue();
                for (int y = 0; y < n; ++y) {
                    int index = y * m + x;
                    data[0][index] = 1 + x;
                    data[1][index] = y;
                    int mask = this.flagDescriptors[y].getMask();
                    data[2][index] = (flags & mask) == mask ? (double)(1 + y % 3) : 0.0;
                }
            }
            this.dataset.addSeries((Comparable)((Object)SERIES_KEY), data);
        } else {
            this.plot.setNoDataMessage("Not a SMOS D1C/F1C pixel.");
        }
        this.chart.fireChartChanged();
    }

    @Override
    protected void updateGridPointBtDataComponent(IOException e) {
        this.dataset.removeSeries((Comparable)((Object)SERIES_KEY));
        this.plot.setNoDataMessage("I/O error");
    }

    @Override
    protected void clearGridPointBtDataComponent() {
        if (this.dataset != null) {
            this.dataset.removeSeries((Comparable)((Object)SERIES_KEY));
        }
        if (this.plot != null) {
            this.plot.setNoDataMessage("No data");
        }
    }

    private String[] createFlagNames(FlagDescriptor[] flagDescriptors) {
        String[] flagNames = new String[flagDescriptors.length];
        for (int i = 0; i < flagDescriptors.length; ++i) {
            flagNames[i] = flagDescriptors[i].getFlagName();
        }
        return flagNames;
    }

    private NumberAxis createRangeAxis(String[] flagNames) {
        SymbolAxis axis = new SymbolAxis(null, flagNames);
        axis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        axis.setAutoRangeIncludesZero(false);
        axis.setLowerMargin(0.0);
        axis.setUpperMargin(0.0);
        axis.setInverted(true);
        return axis;
    }

    private class FlagToolTipGenerator
    implements XYZToolTipGenerator {
        private String[] flagNames;

        private FlagToolTipGenerator(String[] flagNames) {
            this.flagNames = flagNames;
        }

        public String generateToolTip(XYDataset xyDataset, int series, int item) {
            return this.generateToolTip((XYZDataset)xyDataset, series, item);
        }

        public String generateToolTip(XYZDataset xyzDataset, int series, int item) {
            int recordIndex = GridPointBtDataFlagmatrixTopComponent.this.dataset.getX(series, item).intValue();
            int flagIndex = GridPointBtDataFlagmatrixTopComponent.this.dataset.getY(series, item).intValue();
            boolean flagSet = GridPointBtDataFlagmatrixTopComponent.this.dataset.getZ(series, item).intValue() != 0;
            String flagName = "?";
            if (flagIndex >= 0 && flagIndex < this.flagNames.length) {
                flagName = this.flagNames[flagIndex];
            }
            return flagName + "(" + recordIndex + "): " + (flagSet ? "ON" : "OFF");
        }
    }
}

