/*
 * Decompiled with CFR 0.152.
 */
package org.esa.smos.gui.gridpoint;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.esa.smos.dataio.smos.GridPointBtDataset;
import org.esa.smos.dataio.smos.PolarisationModel;
import org.esa.smos.dataio.smos.SmosReader;
import org.esa.smos.gui.gridpoint.GridPointBtDataTopComponent;
import org.esa.snap.ui.product.ProductSceneView;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.DeviationRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.YIntervalSeries;
import org.jfree.data.xy.YIntervalSeriesCollection;
import org.jfree.ui.RectangleInsets;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="GridPointBtDataChartTopComponent", iconBase="org/esa/smos/icons/SmosBtGraph.png", persistenceType=0)
public class GridPointBtDataChartTopComponent
extends GridPointBtDataTopComponent {
    static final String DISPLAY_NAME = "SMOS L1C Chart";
    private JFreeChart chart;
    private YIntervalSeriesCollection coPolDataset;
    private YIntervalSeriesCollection crossPolDataset;
    private XYPlot plot;
    private JCheckBox[] modeCheckers;
    private PolarisationModel polarisationModel;

    public GridPointBtDataChartTopComponent() {
        this.setDisplayName(DISPLAY_NAME);
    }

    @Override
    protected JComponent createGridPointComponent() {
        this.coPolDataset = new YIntervalSeriesCollection();
        this.crossPolDataset = new YIntervalSeriesCollection();
        this.chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.coPolDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        this.plot = this.chart.getXYPlot();
        this.plot.setNoDataMessage("No data");
        this.plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        NumberAxis xAxis = (NumberAxis)this.plot.getDomainAxis();
        xAxis.setLabel("Incidence Angle (deg)");
        xAxis.setRange(0.0, 70.0);
        xAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis yAxis = (NumberAxis)this.plot.getRangeAxis();
        yAxis.setLabel("Co-Pol BT(K)");
        yAxis.setRange(50.0, 350.0);
        NumberAxis yAxis2 = new NumberAxis("Cross-Pol BT(K)");
        yAxis2.setRange(-25.0, 25.0);
        this.plot.setRangeAxis(1, (ValueAxis)yAxis2);
        this.plot.setDataset(1, (XYDataset)this.crossPolDataset);
        this.plot.mapDatasetToRangeAxis(1, 1);
        DeviationRenderer coPolRenderer = new DeviationRenderer(true, false);
        coPolRenderer.setSeriesFillPaint(0, (Paint)new Color(255, 127, 127));
        coPolRenderer.setSeriesFillPaint(1, (Paint)new Color(127, 127, 255));
        DeviationRenderer crossPolRenderer = new DeviationRenderer(true, false);
        crossPolRenderer.setSeriesFillPaint(0, (Paint)new Color(127, 255, 127));
        crossPolRenderer.setSeriesFillPaint(1, (Paint)new Color(255, 255, 127));
        this.plot.setRenderer(0, (XYItemRenderer)coPolRenderer);
        this.plot.setRenderer(1, (XYItemRenderer)crossPolRenderer);
        return new ChartPanel(this.chart);
    }

    @Override
    protected void updateClientComponent(ProductSceneView smosView) {
        SmosReader smosReader = this.getSelectedSmosReader();
        if (smosReader != null && smosReader.canSupplyGridPointBtData()) {
            this.modeCheckers[0].setEnabled(true);
            this.modeCheckers[1].setEnabled(true);
            this.modeCheckers[2].setEnabled(smosReader.canSupplyFullPolData());
            this.polarisationModel = smosReader.getPolarisationModel();
        }
    }

    @Override
    protected JComponent createGridPointComponentOptionsComponent() {
        this.modeCheckers = new JCheckBox[]{new JCheckBox("X", true), new JCheckBox("Y", true), new JCheckBox("XY", true)};
        JPanel optionsPanel = new JPanel(new FlowLayout(2, 2, 2));
        for (JCheckBox modeChecker : this.modeCheckers) {
            modeChecker.addActionListener(e -> this.updateGridPointBtDataComponent());
            optionsPanel.add(modeChecker);
        }
        return optionsPanel;
    }

    @Override
    protected void updateGridPointBtDataComponent(GridPointBtDataset ds) {
        this.coPolDataset.removeAllSeries();
        this.crossPolDataset.removeAllSeries();
        int ix = ds.getIncidenceAngleBandIndex();
        int iq = ds.getPolarisationFlagBandIndex();
        int id = ds.getRadiometricAccuracyBandIndex();
        if (ix != -1 && iq != -1 && id != -1) {
            int iy1 = ds.getColumnIndex("BT_Value");
            if (iy1 != -1) {
                Number[][] data;
                YIntervalSeries series1 = new YIntervalSeries((Comparable)((Object)"X"));
                YIntervalSeries series2 = new YIntervalSeries((Comparable)((Object)"Y"));
                boolean m1 = this.modeCheckers[0].isSelected();
                boolean m2 = this.modeCheckers[1].isSelected();
                for (Number[] dataList : data = ds.getData()) {
                    int polMode = this.polarisationModel.getPolarisationMode(dataList[iq].intValue());
                    double x = dataList[ix].doubleValue();
                    double y = dataList[iy1].doubleValue();
                    double dev = dataList[id].doubleValue();
                    if (m1 && this.polarisationModel.is_X_Polarised(polMode)) {
                        series1.add(x, y, y - dev, y + dev);
                        continue;
                    }
                    if (!m2 || !this.polarisationModel.is_Y_Polarised(polMode)) continue;
                    series2.add(x, y, y - dev, y + dev);
                }
                this.coPolDataset.addSeries(series1);
                this.coPolDataset.addSeries(series2);
            } else {
                iy1 = ds.getBTValueRealBandIndex();
                int iy2 = ds.getBTValueImaginaryBandIndex();
                if (iy1 != -1 && iy2 != -1) {
                    Number[][] data;
                    YIntervalSeries series1 = new YIntervalSeries((Comparable)((Object)"X"));
                    YIntervalSeries series2 = new YIntervalSeries((Comparable)((Object)"Y"));
                    YIntervalSeries series3 = new YIntervalSeries((Comparable)((Object)"XY_Real"));
                    YIntervalSeries series4 = new YIntervalSeries((Comparable)((Object)"XY_Imag"));
                    boolean m1 = this.modeCheckers[0].isSelected();
                    boolean m2 = this.modeCheckers[1].isSelected();
                    boolean m3 = this.modeCheckers[2].isSelected();
                    for (Number[] dataList : data = ds.getData()) {
                        int polMode = this.polarisationModel.getPolarisationMode(dataList[iq].intValue());
                        double dev = dataList[id].doubleValue();
                        double x = dataList[ix].doubleValue();
                        double y1 = dataList[iy1].doubleValue();
                        if (m1 && this.polarisationModel.is_X_Polarised(polMode)) {
                            series1.add(x, y1, y1 - dev, y1 + dev);
                            continue;
                        }
                        if (m2 && this.polarisationModel.is_Y_Polarised(polMode)) {
                            series2.add(x, y1, y1 - dev, y1 + dev);
                            continue;
                        }
                        if (!m3 || !this.polarisationModel.is_XY1_Polarised(polMode) && !this.polarisationModel.is_XY2_Polarised(polMode)) continue;
                        double y2 = dataList[iy2].doubleValue();
                        series3.add(x, y1, y1 - dev, y1 + dev);
                        series4.add(x, y2, y2 - dev, y2 + dev);
                    }
                    this.coPolDataset.addSeries(series1);
                    this.coPolDataset.addSeries(series2);
                    this.crossPolDataset.addSeries(series3);
                    this.crossPolDataset.addSeries(series4);
                }
            }
        } else {
            this.plot.setNoDataMessage("Not a SMOS SCxD1C/SCxF1C pixel.");
        }
        this.chart.fireChartChanged();
    }

    @Override
    protected void updateGridPointBtDataComponent(IOException e) {
        this.coPolDataset.removeAllSeries();
        this.crossPolDataset.removeAllSeries();
        this.plot.setNoDataMessage("I/O error");
    }

    @Override
    protected void clearGridPointBtDataComponent() {
        if (this.coPolDataset != null) {
            this.coPolDataset.removeAllSeries();
        }
        if (this.crossPolDataset != null) {
            this.crossPolDataset.removeAllSeries();
        }
        if (this.plot != null) {
            this.plot.setNoDataMessage("No data");
        }
    }
}

